/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller;

import com.webmcq.ld.controller.Activity;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.MultiTaskInstance;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dto.ActivityData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.controller.learner.Group;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ActivityInstance {
    private long sid;
    private Activity activity;
    private int status;
    private List taskInstances;
    private long activityId;
    private LearningSession learningSession;
    private Group group;

    private ActivityInstance() {
    }

    public ActivityInstance(Activity activity) {
        this.activity = activity;
        this.status = 1;
        this.activityId = activity.getSid();
        this.taskInstances = new ArrayList();
    }

    public ActivityInstance(Activity activity, LearningSession lsess, Group group) {
        this.activity = activity;
        this.status = 1;
        this.activityId = activity.getSid();
        this.learningSession = lsess;
        this.group = group;
    }

    public int getStatus() {
        return this.status;
    }

    public List getTaskInstances() {
        return this.taskInstances;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    private void setTaskInstances(List taskInstances) {
        this.taskInstances = taskInstances;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ActivityInstance)) {
            return false;
        }
        ActivityInstance other = (ActivityInstance)obj;
        return !(this.activity == null ? other.activity != null : this.activity.getSid() != other.activity.getSid());
    }

    public ActivityData getData(String mode, Learner learner) {
        ActivityData data = new ActivityData(this.activity.getSid(), this.activity.getTitle(), this.activity.getDescription(), false);
        data.setStatus(4);
        data.setTasks(this.toTaskInstaceData(this.taskInstances, mode, learner));
        return data;
    }

    private List toTaskInstaceData(List taskInstances, String mode, Learner learner) {
        this.removeDuplicate(taskInstances);
        ArrayList<TaskInstanceData> tasks = new ArrayList<TaskInstanceData>();
        Iterator iter = taskInstances.iterator();
        while (iter.hasNext()) {
            TaskInstance task = (TaskInstance)iter.next();
            if (task instanceof MultiTaskInstance) {
                MultiTaskInstance mTask = (MultiTaskInstance)task;
                tasks.add(this.getData(mTask.getTaskInstance1(), mode, learner));
                tasks.add(this.getData(mTask.getTaskInstance2(), mode, learner));
                continue;
            }
            tasks.add(this.getData(task, mode, learner));
        }
        return tasks;
    }

    private TaskInstanceData getData(TaskInstance taskInstance, String mode, Learner learner) {
        TaskInstanceData data = taskInstance.getData();
        if ("checkup".equals(mode)) {
            String[] urls = taskInstance.checkup(learner);
            data.setUrl(urls[0]);
        } else {
            data.setUrl(taskInstance.view().getUrlA());
        }
        return data;
    }

    private void removeDuplicate(List taskInstances) {
        Iterator iter = taskInstances.iterator();
        TaskInstance last = null;
        while (iter.hasNext()) {
            TaskInstance task = (TaskInstance)iter.next();
            if (task.equals(last)) {
                iter.remove();
            }
            last = task;
        }
    }

    public long getSid() {
        return this.sid;
    }

    private void setSid(long sid) {
        this.sid = sid;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public long getActivityId() {
        return this.activityId;
    }

    private void setActivityId(long activityId) {
        this.activityId = activityId;
    }

    public Group getGroup() {
        return this.group;
    }

    public LearningSession getLearningSession() {
        return this.learningSession;
    }

    private void setGroup(Group group) {
        this.group = group;
    }

    private void setLearningSession(LearningSession learningSession) {
        this.learningSession = learningSession;
    }

    public void addTaskInstance(TaskInstance task) {
        this.taskInstances.add(task);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

