/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.ToolProxy;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.controller.learner.Group;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class TaskInstance {
    private long sid;
    private Map participants;
    private LearningSession lsession;
    private Group group;
    private long taskSid;
    private boolean locked;
    private String uniqueCheck;

    protected TaskInstance() {
    }

    protected TaskInstance(LearningSession lsession, Group group) {
        this.lsession = lsession;
        this.participants = new HashMap();
        this.group = group;
        this.locked = false;
    }

    public long getSid() {
        return this.sid;
    }

    protected void setSid(long sid) {
        this.sid = sid;
    }

    public void participate(Learner learner) {
        this.participants.put(new Long(learner.getUserId()), learner);
    }

    public Learner getParticipant(long sysUserId) {
        return (Learner)this.participants.get(new Long(sysUserId));
    }

    public Map getParticipants() {
        return this.participants;
    }

    public int getParticipantsCount() {
        return this.participants.size();
    }

    public void setParticipants(Map participants) {
        this.participants = participants;
    }

    public LearningSession getLearningSession() {
        return this.lsession;
    }

    public void setLearningSession(LearningSession lsession) {
        this.lsession = lsession;
    }

    public abstract void complete(Learner var1);

    public abstract boolean hasCompleted(Learner var1);

    public abstract boolean isComplete();

    public Group getGroup() {
        return this.group;
    }

    private void setGroup(Group group) {
        this.group = group;
    }

    public int getGroupSize() {
        return this.group.size();
    }

    public long getTaskSid() {
        return this.taskSid;
    }

    protected void setTaskSid(long taskSid) {
        this.taskSid = taskSid;
    }

    public int getType() {
        return this.getTask().getType();
    }

    public abstract TaskInstanceData getData();

    public abstract Task getTask();

    public abstract void prepareTool() throws ControllerException;

    public abstract DisplayTaskData run(Learner var1);

    public abstract DisplayTaskData resume(Learner var1);

    public abstract DisplayTaskData view();

    public abstract String[] checkup(Learner var1);

    public abstract ToolProxy getToolProxy();

    public abstract void setToolProxy(ToolProxy var1);

    public abstract String getToolType();

    public String toString() {
        return new ToStringBuilder((Object)this).append("sid", this.sid).append("participants", (Object)this.participants).append("learning session", (Object)this.lsession).append("group id", (Object)this.group).append("taskSid", this.taskSid).toString();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean b) {
        this.locked = b;
    }

    public String getUniqueCheck() {
        return this.uniqueCheck;
    }

    public void setUniqueCheck(String uniqueCheck) {
        this.uniqueCheck = uniqueCheck;
    }
}

