/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller;

import com.webmcq.ld.content.Content;
import com.webmcq.ld.content.ContentException;
import com.webmcq.ld.content.LDContentKey;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.SyncTaskInstance;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.ToolNotFoundException;
import com.webmcq.ld.controller.dto.ControllerDTOFactory;
import com.webmcq.ld.service.ContentServiceDelegate;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.tool.ToolEJBRemote;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.util.EJBUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class ToolProxy
implements Serializable {
    private long sid;
    private String name;
    private String type;
    private String learnerUrl;
    private String jndiName;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$ToolProxy == null ? (class$com$webmcq$ld$controller$ToolProxy = ToolProxy.class$("com.webmcq.ld.controller.ToolProxy")) : class$com$webmcq$ld$controller$ToolProxy));
    static /* synthetic */ Class class$com$webmcq$ld$controller$ToolProxy;

    private ToolProxy() {
    }

    public ToolProxy(String name, String type, String learnerURL, String jndiName) {
        this.name = name;
        this.type = type;
        this.learnerUrl = learnerURL;
        this.jndiName = jndiName;
    }

    public void bindTaskInstance(TaskInstance taskInstance) throws ControllerException, SystemException {
        try {
            log.debug((Object)"bindTaskInstance");
            Task task = taskInstance.getTask();
            if (!task.isSingleTask()) {
                throw new ControllerException("only a single-task can be bound: task id '" + task.getSid() + "'");
            }
            taskInstance.setToolProxy(this);
            if (taskInstance instanceof SyncTaskInstance) {
                return;
            }
            long learningDesignId = taskInstance.getLearningSession().getLearningDesignId();
            long learningSessionId = taskInstance.getLearningSession().getSid();
            Long inputContentId = this.getInputContentId(learningDesignId, task.getInputContentId(), learningSessionId);
            log.debug((Object)("input content id found: '" + inputContentId + "'"));
            Long outputContentId = this.getOutputContentId(learningDesignId, task.getOutputContentId(), learningSessionId);
            log.debug((Object)("output content id found: '" + outputContentId + "'"));
            ToolEJBRemote service = this.getServiceInterface();
            service.createSession(task.getTask(), taskInstance.getData(), ControllerDTOFactory.buildGroupData(taskInstance.getGroup(), learningSessionId), "learning.content.controller", inputContentId, outputContentId);
            service.remove();
            log.debug((Object)this.getUrl(taskInstance));
        }
        catch (ToolException e) {
            throw new ControllerException(e);
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
        catch (RemoveException e) {
            throw new SystemException(e);
        }
        catch (ContentException e) {
            e.printStackTrace();
            throw new SystemException(e);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    private ToolEJBRemote getServiceInterface() throws SystemException {
        try {
            InitialContext ctx = new InitialContext(EJBUtil.getContextEnv());
            Object home = ctx.lookup(this.jndiName);
            Object[] parameterTypes = new Class[]{};
            Method method = home.getClass().getMethod("create", (Class<?>[])parameterTypes);
            return (ToolEJBRemote)method.invoke(home, parameterTypes);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    private Long getInputContentId(long learningDesignId, Long ldContentId, long learningSessionId) throws ContentException, ControllerException {
        log.debug((Object)("getInputContentId: ldid: '" + learningDesignId + "', ldContentId: '" + ldContentId + "', lsid: '" + learningSessionId + "'"));
        if (ldContentId == null) {
            return null;
        }
        Content content = ContentServiceDelegate.getContent(ldContentId);
        if (content.isReplaceWithDynamic()) {
            log.debug((Object)("dynamic input content found: " + content));
            long contentId = this.getContentId(learningDesignId, ldContentId, learningSessionId);
            return new Long(contentId);
        }
        log.debug((Object)("static input content found: " + content));
        return ldContentId;
    }

    private Long getOutputContentId(long learningDesignId, Long ldContentid, long learningSessionId) throws ControllerException {
        log.debug((Object)("getOutputContentId: ldid: '" + learningDesignId + "', ldContentId: '" + ldContentid + "', lsid: '" + learningSessionId + "'"));
        if (ldContentid == null) {
            return null;
        }
        long outputContentId = ContentServiceDelegate.issueContentId(learningDesignId, ldContentid, learningSessionId);
        return new Long(outputContentId);
    }

    private long getContentId(long learningDesignId, long contentId, long learningSessionId) throws ContentException, ControllerException {
        LDContentKey contentKey = new LDContentKey(learningDesignId, contentId, learningSessionId);
        Long id = ContentServiceDelegate.getContentId(contentKey);
        if (id != null) {
            return id;
        }
        return ContentServiceDelegate.issueContentId(learningDesignId, contentId, learningSessionId);
    }

    public String getUrl(TaskInstance taskInstance) {
        return this.getUrl(taskInstance, "run");
    }

    public String getUrl(TaskInstance taskInstance, String accessMode) {
        return this.learnerUrl + "&sessionId=" + taskInstance.getSid() + "&mode=" + accessMode + "&locked=" + taskInstance.isLocked();
    }

    public static ToolProxy findToolProxy(String tooltype) throws ToolNotFoundException, ControllerException {
        return LearnerServiceDelegate.findToolProxy(tooltype);
    }

    public String getLearnerUrl() {
        return this.learnerUrl;
    }

    public String getName() {
        return this.name;
    }

    public long getSid() {
        return this.sid;
    }

    public String getType() {
        return this.type;
    }

    private void setLearnerUrl(String learnerUrl) {
        this.learnerUrl = learnerUrl;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setSid(long sid) {
        this.sid = sid;
    }

    private void setType(String type) {
        this.type = type;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    private void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void unbindTaskInstance(TaskInstance taskInstance) throws ControllerException, SystemException {
        try {
            Task task = taskInstance.getTask();
            taskInstance.setToolProxy(this);
            long learningDesignId = taskInstance.getLearningSession().getLearningDesignId();
            long learningSessionId = taskInstance.getLearningSession().getSid();
            Long inputContentId = this.getInputContentId(learningDesignId, task.getInputContentId(), learningSessionId);
            Long outputContentId = this.getOutputContentId(learningDesignId, task.getOutputContentId(), learningSessionId);
            ToolEJBRemote service = this.getServiceInterface();
            service.deleteSession(taskInstance, inputContentId, outputContentId);
            service.remove();
        }
        catch (ToolException e) {
            throw new ControllerException(e);
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
        catch (RemoveException e) {
            throw new SystemException(e);
        }
        catch (ContentException e) {
            e.printStackTrace();
            throw new SystemException(e);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

