/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.dao;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.MultiTaskInstance;
import com.webmcq.ld.controller.OptionalTaskInstance;
import com.webmcq.ld.controller.SingleTaskInstance;
import com.webmcq.ld.controller.SyncTaskInstance;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.learner.Group;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.BaseDAO;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Query;
import net.sf.hibernate.type.Type;
import org.apache.log4j.Logger;

public class TaskInstanceDAO
extends BaseDAO {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$dao$TaskInstanceDAO == null ? (class$com$webmcq$ld$controller$dao$TaskInstanceDAO = TaskInstanceDAO.class$("com.webmcq.ld.controller.dao.TaskInstanceDAO")) : class$com$webmcq$ld$controller$dao$TaskInstanceDAO));
    static /* synthetic */ Class class$com$webmcq$ld$controller$dao$TaskInstanceDAO;
    static /* synthetic */ Class class$com$webmcq$ld$controller$TaskInstance;
    static /* synthetic */ Class class$com$webmcq$ld$controller$OptionalTaskInstance;

    public TaskInstanceDAO(PersistenceSession sess) {
        super(sess);
    }

    public void insert(TaskInstance taskInstance) throws JDBCException, SystemException {
        log.debug((Object)("insert: " + taskInstance));
        super.update(taskInstance);
    }

    public void update(TaskInstance taskInstance) throws SystemException {
        log.debug((Object)("update: " + taskInstance));
        super.update(taskInstance, taskInstance.getSid());
    }

    public void remove(TaskInstance taskInstance) throws SystemException {
        log.debug((Object)("remove: " + taskInstance));
        super.remove(class$com$webmcq$ld$controller$TaskInstance == null ? (class$com$webmcq$ld$controller$TaskInstance = TaskInstanceDAO.class$("com.webmcq.ld.controller.TaskInstance")) : class$com$webmcq$ld$controller$TaskInstance, taskInstance.getSid());
    }

    public TaskInstance find(long taskInstanceId) throws TaskInstanceNotFoundException, SystemException {
        TaskInstance taskInstance = (TaskInstance)super.find(class$com$webmcq$ld$controller$TaskInstance == null ? (class$com$webmcq$ld$controller$TaskInstance = TaskInstanceDAO.class$("com.webmcq.ld.controller.TaskInstance")) : class$com$webmcq$ld$controller$TaskInstance, taskInstanceId);
        if (taskInstance == null) {
            throw new TaskInstanceNotFoundException(taskInstanceId);
        }
        return taskInstance;
    }

    public TaskInstance findMultiTask(long learnerId, long taskInstanceId) throws SystemException {
        log.debug((Object)("findMultiTask: " + learnerId + ":" + taskInstanceId));
        try {
            List list = this.sess.persistece().find("select task from task in class com.webmcq.ld.controller.MultiTaskInstance, learner in task.participants.elements where (task.taskInstance1 = ? or task.taskInstance2 = ?) and learner.sid = ? ", new Object[]{new Long(taskInstanceId), new Long(taskInstanceId), new Long(learnerId)}, new Type[]{Hibernate.LONG, Hibernate.LONG, Hibernate.LONG});
            if (list.size() == 0) {
                return null;
            }
            return (TaskInstance)list.get(0);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public TaskInstance find(LearningSession lsession, long TaskId, Group group) throws SystemException {
        try {
            log.debug((Object)("find: learning session '" + lsession.getSid() + "' group '" + group.getSid() + "'"));
            List list = this.sess.persistece().find("from task in class com.webmcq.ld.controller.TaskInstance where task.learningSession.sid = ? and task.group.sid = ? and task.taskSid = ?", new Object[]{new Long(lsession.getSid()), new Long(group.getSid()), new Long(TaskId)}, new Type[]{Hibernate.LONG, Hibernate.LONG, Hibernate.LONG});
            if (list.size() == 0) {
                log.debug((Object)"task instance not found");
                return null;
            }
            log.debug((Object)"task instance found");
            return (TaskInstance)list.get(0);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public TaskInstance findMultiTask(LearningSession lsession, long TaskId, TaskInstance subTask1, TaskInstance subTask2) throws SystemException {
        try {
            log.debug((Object)("findMultiTask: learning session '" + lsession.getSid() + "'"));
            List list = this.sess.persistece().find("from task in class com.webmcq.ld.controller.MultiTaskInstance where task.learningSession.sid = ? and task.taskSid = ? and task.taskInstance1.sid = ? and task.taskInstance2.sid = ?", new Object[]{new Long(lsession.getSid()), new Long(TaskId), new Long(subTask1.getSid()), new Long(subTask2.getSid())}, new Type[]{Hibernate.LONG, Hibernate.LONG, Hibernate.LONG, Hibernate.LONG});
            if (list.size() == 0) {
                log.debug((Object)"multi-task instance not found");
                return null;
            }
            log.debug((Object)"multi-task instance found");
            return (TaskInstance)list.get(0);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public boolean isPartOfMultiTask(long learnerId, long taskInstanceId) {
        TaskInstance taskInstance = this.findMultiTask(learnerId, taskInstanceId);
        return taskInstance != null;
    }

    public TaskInstance findOptionalTask(LearningSession lsession, long TaskId) throws SystemException {
        try {
            log.debug((Object)("findOptionalTask: learning session '" + lsession.getSid() + "'"));
            List list = this.sess.persistece().find("from task in class com.webmcq.ld.controller.OptionalTaskInstance where task.learningSession.sid = ? and task.taskSid = ?", new Object[]{new Long(lsession.getSid()), new Long(TaskId)}, new Type[]{Hibernate.LONG, Hibernate.LONG});
            if (list.size() == 0) {
                log.debug((Object)"optional-task instance not found");
                return null;
            }
            log.debug((Object)"optional-task instance found");
            return (TaskInstance)list.get(0);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public TaskInstance findOptionalTask(LearningSession lsession, long TaskId, String uniqueCheck) throws SystemException {
        try {
            log.debug((Object)("findOptionalTask: learning session '" + lsession.getSid() + "'"));
            List list = this.sess.persistece().find("from task in class com.webmcq.ld.controller.OptionalTaskInstance where task.learningSession.sid = ? and task.taskSid = ? and task.uniqueCheck = ?", new Object[]{new Long(lsession.getSid()), new Long(TaskId), uniqueCheck}, new Type[]{Hibernate.LONG, Hibernate.LONG, Hibernate.STRING});
            if (list.size() == 0) {
                log.debug((Object)"optional-task instance not found");
                return null;
            }
            log.debug((Object)"optional-task instance found");
            return (TaskInstance)list.get(0);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public TaskInstance findOptionalEagerly(long taskInstanceId) throws SystemException, ControllerException, TaskInstanceNotFoundException {
        try {
            log.debug((Object)"findOptionalTask");
            TaskInstance taskInstance = (TaskInstance)this.sess.persistece().get(class$com$webmcq$ld$controller$OptionalTaskInstance == null ? (class$com$webmcq$ld$controller$OptionalTaskInstance = TaskInstanceDAO.class$("com.webmcq.ld.controller.OptionalTaskInstance")) : class$com$webmcq$ld$controller$OptionalTaskInstance, (Serializable)new Long(taskInstanceId));
            if (taskInstance == null) {
                log.debug((Object)"task instance not found");
                throw new TaskInstanceNotFoundException(taskInstanceId);
            }
            log.debug((Object)"task instance found");
            if (!(taskInstance instanceof OptionalTaskInstance)) {
                throw new ControllerException("not an optional task instance: '" + taskInstanceId + "'");
            }
            OptionalTaskInstance optionalTaskInstance = (OptionalTaskInstance)taskInstance;
            Hibernate.initialize((Object)optionalTaskInstance.getSubTaskInstances());
            this.sess.flush();
            Iterator iter = optionalTaskInstance.getSubTaskInstances().iterator();
            while (iter.hasNext()) {
                TaskInstance subTaskInstance = (TaskInstance)iter.next();
                if (subTaskInstance instanceof MultiTaskInstance) {
                    MultiTaskInstance multiTaskInstance = (MultiTaskInstance)subTaskInstance;
                    SingleTaskInstance taskInstance1 = (SingleTaskInstance)multiTaskInstance.getTaskInstance1();
                    Hibernate.initialize((Object)taskInstance1.getCompletedLearners());
                    SingleTaskInstance taskInstance2 = (SingleTaskInstance)multiTaskInstance.getTaskInstance1();
                    Hibernate.initialize((Object)taskInstance2.getCompletedLearners());
                    continue;
                }
                if (subTaskInstance instanceof SingleTaskInstance) {
                    SingleTaskInstance singleTaskInstance = (SingleTaskInstance)subTaskInstance;
                    Hibernate.initialize((Object)singleTaskInstance.getCompletedLearners());
                    continue;
                }
                throw new ControllerException("Unexpected taskInstance type. taskInstanceId:" + subTaskInstance.getSid());
            }
            return taskInstance;
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public TaskInstance findSyncTask(LearningSession lsession, long TaskId) throws SystemException {
        try {
            log.debug((Object)("findWaitingTask: learning session '" + lsession.getSid() + "'"));
            Query findSyncTaskQuery = this.sess.persistece().createQuery("from com.webmcq.ld.controller.SyncTaskInstance task  where task.learningSession.sid = ? and task.taskSid = ?");
            findSyncTaskQuery.setLong(0, lsession.getSid());
            findSyncTaskQuery.setLong(1, TaskId);
            findSyncTaskQuery.setLockMode("task", LockMode.UPGRADE);
            List list = findSyncTaskQuery.list();
            if (list.size() == 0) {
                log.debug((Object)"sync-task instance not found");
                return null;
            }
            log.debug((Object)"sync-task instance found");
            return (TaskInstance)list.get(0);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public SyncTaskInstance findSyncTaskInstance(long taskInstanceId) throws TaskInstanceNotFoundException, SystemException {
        log.debug((Object)("findSyncTask: task instance id '" + taskInstanceId + "'"));
        TaskInstance taskInstance = this.find(taskInstanceId);
        if (taskInstance == null) {
            throw new TaskInstanceNotFoundException("task instance '" + taskInstanceId + "' not found");
        }
        if (!(taskInstance instanceof SyncTaskInstance)) {
            throw new TaskInstanceNotFoundException("sync task instance '" + taskInstanceId + "' not found. task instance is wrong type: '" + taskInstance.getClass() + "'");
        }
        return (SyncTaskInstance)taskInstance;
    }

    public SyncTaskInstance[] findAllSyncTasks(long learningSessionId) throws SystemException {
        try {
            log.debug((Object)("findAllSyncTasks: learning session '" + learningSessionId + "'"));
            List list = this.sess.persistece().find("from task in class com.webmcq.ld.controller.SyncTaskInstance where task.learningSession.sid = ?", (Object)new Long(learningSessionId), (Type)Hibernate.LONG);
            return list.toArray(new SyncTaskInstance[list.size()]);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public TaskInstance[] findAll(long learningSessionId) throws SystemException {
        try {
            List list = this.sess.persistece().find("from task in class com.webmcq.ld.controller.TaskInstance where task.learningSession.sid = ?", (Object)new Long(learningSessionId), (Type)Hibernate.LONG);
            return list.toArray(new TaskInstance[0]);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public TaskInstance[] find(long learningSessionId, String tooltype) {
        TaskInstance[] tasks = this.findAll(learningSessionId);
        ArrayList<TaskInstance> selected = new ArrayList<TaskInstance>();
        for (int i = 0; i < tasks.length; ++i) {
            if (!tooltype.equals(tasks[i].getToolType())) continue;
            selected.add(tasks[i]);
        }
        return selected.toArray(new TaskInstance[0]);
    }

    public TaskInstance[] find(long learningSessionId, long taskId) {
        try {
            List list = this.sess.persistece().find("from task in class com.webmcq.ld.controller.TaskInstance where task.learningSession.sid = ? and task.taskSid = ?", new Object[]{new Long(learningSessionId), new Long(taskId)}, new Type[]{Hibernate.LONG, Hibernate.LONG});
            return list.toArray(new TaskInstance[list.size()]);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

