/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.service;

import com.webmcq.ld.controller.dto.ClientSessionData;
import com.webmcq.ld.controller.web.ClientSessionDataManager;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.usermanagement.LcwUser;
import com.webmcq.ld.usermanagement.OrganisationCompleteData;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.UserManagementException;
import com.webmcq.ld.usermanagement.dao.hibernate.LcwUserDAO;
import com.webmcq.ld.usermanagement.interfaces.OrganisationData;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.usermanagement.interfaces.UserManagementService;
import com.webmcq.ld.usermanagement.interfaces.UserManagementServiceHome;
import com.webmcq.ld.util.EJBHomeFactory;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import net.sf.hibernate.HibernateException;
import org.apache.log4j.Logger;

public class UserServiceDelegate {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$service$UserServiceDelegate == null ? (class$com$webmcq$ld$service$UserServiceDelegate = UserServiceDelegate.class$("com.webmcq.ld.service.UserServiceDelegate")) : class$com$webmcq$ld$service$UserServiceDelegate));
    static /* synthetic */ Class class$com$webmcq$ld$service$UserServiceDelegate;
    static /* synthetic */ Class class$com$webmcq$ld$usermanagement$interfaces$UserManagementServiceHome;

    public static ShwaaUserData find(String login) throws UserNotFoundException {
        if (login == null) {
            throw new EJBException("Unable to find user as login is null");
        }
        ShwaaUserData sysUser = null;
        try {
            UserManagementService service = UserServiceDelegate.getService();
            sysUser = service.getUser(login);
            UserServiceDelegate.remove(service);
        }
        catch (RemoteException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        if (sysUser == null) {
            throw new UserNotFoundException(login);
        }
        return sysUser;
    }

    public static ShwaaUserData find(long userId) throws UserNotFoundException {
        ShwaaUserData sysUser = null;
        try {
            UserManagementService service = UserServiceDelegate.getService();
            sysUser = service.getUser(new Long(userId));
            UserServiceDelegate.remove(service);
        }
        catch (RemoteException ex) {
            log.error((Object)"Exception occured", (Throwable)ex);
            throw new EJBException((Exception)ex);
        }
        if (sysUser == null) {
            throw new UserNotFoundException(userId);
        }
        return sysUser;
    }

    public static UserData findCompleteUser(String login) throws UserNotFoundException {
        UserData user = null;
        try {
            UserManagementService service = UserServiceDelegate.getService();
            user = service.getCompleteUser(login);
            UserServiceDelegate.remove(service);
        }
        catch (RemoteException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        if (user == null) {
            throw new UserNotFoundException(login);
        }
        return user;
    }

    public static UserData findCompleteUser(long userId) throws UserNotFoundException {
        UserData user = null;
        try {
            UserManagementService service = UserServiceDelegate.getService();
            user = service.getCompleteUser(new Long(userId));
            UserServiceDelegate.remove(service);
        }
        catch (RemoteException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        if (user == null) {
            throw new UserNotFoundException(userId);
        }
        return user;
    }

    public static long findUserId(String login) throws UserNotFoundException {
        long userId = 0L;
        ClientSessionData userSessionData = ClientSessionDataManager.getInstance().getDetails(login);
        if (userSessionData == null) {
            log.error((Object)("the user : " + login + " has not been found"));
        } else {
            userId = userSessionData.getUserID();
        }
        if (userId <= 0L) {
            return UserServiceDelegate.findUserIdBis(login);
        }
        return userId;
    }

    public static long findUserIdBis(String login) throws UserNotFoundException {
        Long id = null;
        try {
            UserManagementService service = UserServiceDelegate.getService();
            id = service.getUserId(login);
            UserServiceDelegate.remove(service);
        }
        catch (RemoteException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        if (id == null) {
            throw new UserNotFoundException(login);
        }
        return id;
    }

    public static OrganisationCompleteData findHomeOrganisation(long userId) throws UserNotFoundException {
        OrganisationCompleteData org = null;
        try {
            UserManagementService service = UserServiceDelegate.getService();
            org = service.getHomeOrganisation(new Long(userId));
            UserServiceDelegate.remove(service);
        }
        catch (UserManagementException e) {
            log.error((Object)"Exception occured accessing home organisation", (Throwable)e);
            throw new UserNotFoundException(userId);
        }
        catch (RemoteException e) {
            log.error((Object)"Exception occured", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        return org;
    }

    public static OrganisationCompleteData findOrganisation(long orgId, long userId) throws UserManagementException, SystemException {
        try {
            UserManagementService service = UserServiceDelegate.getService();
            OrganisationCompleteData org = service.getOrganisation(new Long(orgId), new Long(userId));
            UserServiceDelegate.remove(service);
            log.debug((Object)("findOrganisation: organisation = " + org));
            return org;
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static Set findOrganisations(long userId) throws UserManagementException, SystemException {
        try {
            UserManagementService service = UserServiceDelegate.getService();
            Set orgs = service.getAllOrganisations(new Long(userId));
            UserServiceDelegate.remove(service);
            log.debug((Object)("findOrganisations: organisations = " + orgs.size()));
            return orgs;
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static Set findSessionOrganisations(long userId) throws UserManagementException, SystemException {
        try {
            UserManagementService service = UserServiceDelegate.getService();
            Set orgs = service.getSessionOrganisations(new Long(userId));
            UserServiceDelegate.remove(service);
            log.debug((Object)("findSessionOrganisations: organisations = " + orgs.size()));
            return orgs;
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static OrganisationData[] findSessionOrganisationsLearner(long userId) throws UserManagementException, SystemException {
        try {
            UserManagementService service = UserServiceDelegate.getService();
            OrganisationData[] orgs = service.getSessionOrganisationsLearner(new Long(userId));
            UserServiceDelegate.remove(service);
            log.debug((Object)("findSessionOrganisations: organisations = " + orgs.length));
            return orgs;
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static UserManagementService getService() {
        try {
            UserManagementServiceHome home = (UserManagementServiceHome)EJBHomeFactory.getInstance().lookup("ejb/usermanagement/UserManagementService", class$com$webmcq$ld$usermanagement$interfaces$UserManagementServiceHome == null ? (class$com$webmcq$ld$usermanagement$interfaces$UserManagementServiceHome = UserServiceDelegate.class$("com.webmcq.ld.usermanagement.interfaces.UserManagementServiceHome")) : class$com$webmcq$ld$usermanagement$interfaces$UserManagementServiceHome);
            return home.create();
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private static void remove(UserManagementService service) {
        try {
            service.remove();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long retrieveUserId(String username) throws SystemException {
        long userId = 0L;
        PersistenceSession sessS = new PersistenceSession();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String queryString = "select c.uid from tbl_user c where c.login=?";
        try {
            try {
                conn = sessS.persistece().connection();
                stmt = conn.prepareStatement(queryString);
                stmt.setString(1, username);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    userId = rs.getLong(1);
                }
            }
            catch (HibernateException eHi) {
                throw new SystemException(eHi);
            }
            catch (SQLException sqle) {
                throw new SystemException(sqle);
            }
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                sessS.close();
                throw throwable;
            }
            catch (SQLException sqle2) {
                throw new SystemException(sqle2);
            }
        }
        try {}
        catch (SQLException sqle2) {
            throw new SystemException(sqle2);
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        sessS.close();
        return userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LcwUser getLcwUserById(Long userId) {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LcwUserDAO luDao = new LcwUserDAO(sess);
            LcwUser lcwUser = luDao.getLcwUserById(userId);
            sess.flush();
            LcwUser lcwUser2 = lcwUser;
            return lcwUser2;
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LcwUser getLcwUserByEmail(String email) {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LcwUserDAO luDao = new LcwUserDAO(sess);
            LcwUser lcwUser = luDao.getLcwUserByEmail(email);
            sess.flush();
            LcwUser lcwUser2 = lcwUser;
            return lcwUser2;
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveLcwUser(LcwUser lcwUser) {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LcwUserDAO luDao = new LcwUserDAO(sess);
            luDao.saveLcwUser(lcwUser);
            sess.flush();
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLcwUser(LcwUser lcwUser) {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LcwUserDAO luDao = new LcwUserDAO(sess);
            luDao.updateLcwUser(lcwUser);
            sess.flush();
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveOrUpdateLcwUser(LcwUser lcwUser) {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LcwUserDAO luDao = new LcwUserDAO(sess);
            luDao.saveOrUpdateLcwUser(lcwUser);
            sess.flush();
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLcwUser(LcwUser lcwUser) {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LcwUserDAO luDao = new LcwUserDAO(sess);
            luDao.deleteLcwUser(lcwUser);
            sess.flush();
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLcwUserById(Long userId) {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LcwUserDAO luDao = new LcwUserDAO(sess);
            luDao.deleteLcwUserById(userId);
            sess.flush();
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLcwUserByEmail(String email) {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LcwUserDAO luDao = new LcwUserDAO(sess);
            luDao.deleteLcwUserByEmail(email);
            sess.flush();
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePassword(String email, String newPassword) {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LcwUserDAO luDao = new LcwUserDAO(sess);
            luDao.updatePassword(email, newPassword);
            sess.flush();
        }
        finally {
            sess.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

