/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.ToolUrl;
import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.StaffServiceDelegate;
import com.webmcq.ld.service.interfaces.ConfigurationService;
import com.webmcq.ld.service.interfaces.ConfigurationServiceHome;
import com.webmcq.ld.util.EJBHomeFactory;
import com.webmcq.ld.util.exception.SystemException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class StaffMonitorNotifier {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$StaffMonitorNotifier == null ? (class$com$webmcq$ld$tool$StaffMonitorNotifier = StaffMonitorNotifier.class$("com.webmcq.ld.tool.StaffMonitorNotifier")) : class$com$webmcq$ld$tool$StaffMonitorNotifier));
    static /* synthetic */ Class class$com$webmcq$ld$tool$StaffMonitorNotifier;
    static /* synthetic */ Class class$com$webmcq$ld$service$interfaces$ConfigurationServiceHome;

    private static ConfigurationService getService() {
        try {
            ConfigurationServiceHome home = (ConfigurationServiceHome)EJBHomeFactory.getInstance().lookup("ejb/service/ConfigurationService", class$com$webmcq$ld$service$interfaces$ConfigurationServiceHome == null ? (class$com$webmcq$ld$service$interfaces$ConfigurationServiceHome = StaffMonitorNotifier.class$("com.webmcq.ld.service.interfaces.ConfigurationServiceHome")) : class$com$webmcq$ld$service$interfaces$ConfigurationServiceHome);
            return home.create();
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private static void remove(ConfigurationService service) {
        try {
            service.remove();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public static void notifyControllerOfURL(long taskInstanceId, String toolType, String title, String toolpath) throws ControllerException, SystemException {
        ToolUrl data = new ToolUrl();
        data.setSequenceSessionId(null);
        data.setSid(null);
        data.setTaskInstanceId(new Long(taskInstanceId));
        data.setToolType(toolType);
        if (toolpath != null) {
            data.setUrl(StaffMonitorNotifier.getToolURL(taskInstanceId, toolpath));
        } else {
            data.setUrl(null);
        }
        data.setUrlTitle(title);
        StaffServiceDelegate.updateStaffUrl(data);
    }

    private static String getToolURL(long taskInstanceId, String toolpath) {
        ConfigurationService service = StaffMonitorNotifier.getService();
        String url = toolpath;
        try {
            String servername = service.get(ConfigurationKeys.SERVER_URL);
            log.debug((Object)("getToolURL: servername is " + servername));
            if (servername == null) {
                log.warn((Object)"getToolURL: No servername found in configuration. Monitor URLS will not contain servername");
            } else {
                url = servername + "/lams/" + toolpath;
            }
        }
        catch (RemoteException e) {
            log.error((Object)"getToolURL: Exception occured getting servername. Monitor URL will not contain servername", (Throwable)e);
        }
        StaffMonitorNotifier.remove(service);
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

