/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.chat;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.ContentServiceDelegate;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.service.interfaces.ConfigurationServiceLocal;
import com.webmcq.ld.service.interfaces.ConfigurationServiceUtil;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.tool.chat.ChatTaskException;
import com.webmcq.ld.tool.chat.interfaces.ChatGroupData;
import com.webmcq.ld.tool.chat.interfaces.ChatGroupLocal;
import com.webmcq.ld.tool.chat.interfaces.ChatGroupLocalHome;
import com.webmcq.ld.tool.chat.interfaces.ChatGroupPK;
import com.webmcq.ld.tool.chat.interfaces.ChatGroupUtil;
import com.webmcq.ld.tool.chat.interfaces.ChatUserData;
import com.webmcq.ld.tool.chat.interfaces.ChatUserLocal;
import com.webmcq.ld.tool.chat.interfaces.ChatUserLocalHome;
import com.webmcq.ld.tool.chat.interfaces.ChatUserUtil;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.EJBUtil;
import com.webmcq.ld.util.ParsingUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public abstract class ChatServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$chat$ChatServiceBean == null ? (class$com$webmcq$ld$tool$chat$ChatServiceBean = ChatServiceBean.class$("com.webmcq.ld.tool.chat.ChatServiceBean")) : class$com$webmcq$ld$tool$chat$ChatServiceBean));
    static /* synthetic */ Class class$com$webmcq$ld$tool$chat$ChatServiceBean;

    public void createSession(AbstractTaskVO task, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
        try {
            Content content = null;
            if (inputContentId != null) {
                content = ContentServiceDelegate.getContent(inputContentId);
            }
            this.createSession((SimpleTaskVO)task, taskInstance, group, content);
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ToolException(e);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            e.printStackTrace();
            throw new SystemException(e);
        }
    }

    private void createSession(SimpleTaskVO taskVO, TaskInstanceData instance, GroupData groupData, Content content) throws EJBException {
        try {
            log.debug((Object)"createSession");
            long sessionId = instance.getSid();
            long taskGroupSid = -1L;
            String taskGroupName = null;
            if (groupData != null) {
                taskGroupSid = groupData.getSid();
                taskGroupName = groupData.getName();
                log.debug((Object)("task_group : " + taskGroupSid + " " + taskGroupName));
            }
            ChatGroupLocalHome localHome = ChatGroupUtil.getLocalHome();
            Collection groups = localHome.findBySessionId(sessionId);
            ChatGroupLocal group = null;
            if (groups != null) {
                group = (ChatGroupLocal)EJBUtil.findSingle(groups);
            }
            if (group == null) {
                String title = content.getTitle();
                String description = content.getDescription();
                group = localHome.create(sessionId, title, description);
                group.setTaskGroupId(taskGroupSid);
                log.debug((Object)("created: " + group));
                this.setContent(group, content);
            } else {
                log.debug((Object)("group already exists " + group));
            }
            log.debug((Object)"exiting");
        }
        catch (NamingException e) {
            log.error((Object)e);
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            log.error((Object)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new EJBException(e);
        }
    }

    public void setContent(ChatGroupLocal chatGroup, Content content) throws EJBException, ControllerException {
        int DEFAULT_PORTNUMBER = 9800;
        int UNSIGNED16_MAX_VALUE = 65535;
        int TRUSTED_PORTS = 1024;
        log.debug((Object)("setContent for " + chatGroup));
        String bodyText = null;
        if (content != null) {
            bodyText = content.getBody();
            chatGroup.setContent(bodyText);
        }
        String chatServerDNS = null;
        int portNumber = -1;
        try {
            ConfigurationServiceLocal service = ConfigurationServiceUtil.getLocalHome().create();
            chatServerDNS = service.get(ConfigurationKeys.CHAT_SERVER_NAME);
            portNumber = service.getAsInteger(ConfigurationKeys.CHAT_PORT_NUMBER);
            service.remove();
            log.debug((Object)("getServerURL: '" + chatServerDNS + "'"));
            if (chatServerDNS == null) {
                throw new ControllerException("Chat Server URL not configured");
            }
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
        chatGroup.setChatServerDNS(chatServerDNS);
        log.debug((Object)("chatServerDNS: " + chatServerDNS));
        if (portNumber < 1024 || portNumber > 65535) {
            log.warn((Object)("portNumber out of range: " + portNumber));
            log.warn((Object)"Using default port number9800");
            portNumber = 9800;
        }
        chatGroup.setPortNumber(portNumber);
        log.debug((Object)("portNumber: " + portNumber));
        chatGroup.setIsReusable(ParsingUtil.booleanToInt(content.isReusable()));
    }

    public DisplayTaskData completeSession(long userId, long sessionId) throws ChatTaskException, EJBException {
        try {
            Collection groups = ChatGroupUtil.getLocalHome().findBySessionId(sessionId);
            ChatGroupLocal group = (ChatGroupLocal)EJBUtil.findSingle(groups);
            if (group == null) {
                throw new ChatTaskException("entry not found with session id: " + sessionId);
            }
            DisplayTaskData displayTaskData = LearnerServiceDelegate.moveToNextTask(sessionId, userId);
            return displayTaskData;
        }
        catch (ChatTaskException e) {
            log.error((Object)e);
            throw e;
        }
        catch (NamingException e) {
            log.error((Object)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            log.error((Object)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new EJBException(e);
        }
    }

    public ChatGroupData getChatGroupData(long sessionId) throws EJBException {
        log.debug((Object)("getting ChatGroupData for sessionId: " + sessionId));
        try {
            Collection chatGroups = ChatGroupUtil.getLocalHome().findBySessionId(sessionId);
            if (chatGroups == null) {
                throw new FinderException("  groups not found" + sessionId);
            }
            ChatGroupLocal chatGroup = (ChatGroupLocal)EJBUtil.findSingle(chatGroups);
            if (chatGroup == null) {
                throw new FinderException("  group not found" + sessionId);
            }
            return chatGroup.getData();
        }
        catch (NamingException e) {
            log.error((Object)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            log.error((Object)e);
            return null;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new EJBException(e);
        }
    }

    public ChatUserData getChatUserDataByUserId(long chatGroupSid, long userId) throws EJBException {
        log.debug((Object)("getting chat user data for (chatGroupId, userId): (" + chatGroupSid + ", " + userId + ")"));
        ChatUserData chatUserData = null;
        ChatUserLocalHome chatUserHome = null;
        try {
            chatUserHome = ChatUserUtil.getLocalHome();
        }
        catch (NamingException e) {
            log.error((Object)e);
            throw new EJBException((Exception)e);
        }
        ChatUserLocal chatUser = null;
        try {
            Collection chatUsers = chatUserHome.findByUserId(chatGroupSid, userId);
            if (chatUsers == null) {
                throw new FinderException("  users not found (" + chatGroupSid + "," + userId + ")");
            }
            chatUser = (ChatUserLocal)EJBUtil.findSingle(chatUsers);
        }
        catch (FinderException e) {
            log.error((Object)e);
            chatUser = null;
        }
        if (chatUser == null) {
            log.warn((Object)("  user not found (" + chatGroupSid + "," + userId + ")"));
            return null;
        }
        chatUserData = chatUser.getData();
        log.debug((Object)("  found the chatUser: " + chatUserData));
        return chatUserData;
    }

    public ChatUserData createNewChatUser(long groupSid, long userId, String loginName) throws EJBException {
        log.debug((Object)("creating a new user: " + groupSid + " " + userId + " " + loginName));
        try {
            ChatGroupPK pk = new ChatGroupPK(groupSid);
            ChatGroupLocal chatGroup = ChatGroupUtil.getLocalHome().findByPrimaryKey(pk);
            if (chatGroup == null) {
                throw new FinderException("  group not found (" + groupSid + ")");
            }
            String nickname = loginName;
            String chatLoginName = loginName;
            String chatPassword = "secret";
            ChatUserLocal chatUser = ChatUserUtil.getLocalHome().create(userId, nickname, chatLoginName, chatPassword);
            if (chatUser == null) {
                throw new FinderException("  failed to create a new user");
            }
            chatUser.setChatGroup(chatGroup);
            chatGroup.addUser(chatUser);
            ChatUserData chatUserData = chatUser.getData();
            log.debug((Object)("  new user created: " + chatUserData));
            return chatUserData;
        }
        catch (NamingException e) {
            log.error((Object)e);
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            log.error((Object)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (FinderException e) {
            log.error((Object)e);
            return null;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new EJBException(e);
        }
    }

    public void deleteSession(TaskInstance taskInstance, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

