/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.groupreport;

import com.webmcq.ld.tool.groupreport.ReportLearnerBean;
import com.webmcq.ld.tool.groupreport.interfaces.ReportData;
import com.webmcq.ld.tool.groupreport.interfaces.ReportItemLocal;
import com.webmcq.ld.tool.groupreport.interfaces.ReportItemUtil;
import com.webmcq.ld.tool.groupreport.interfaces.ReportLearnerLocal;
import com.webmcq.ld.tool.groupreport.interfaces.ReportPK;
import com.webmcq.ld.util.BaseEntityBean;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public abstract class ReportBean
extends BaseEntityBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$groupreport$ReportBean == null ? (class$com$webmcq$ld$tool$groupreport$ReportBean = ReportBean.class$("com.webmcq.ld.tool.groupreport.ReportBean")) : class$com$webmcq$ld$tool$groupreport$ReportBean));
    private static int INPROGRESS = 1;
    private static int COMPLETE = 2;
    public static int SCRIBE_CANNOT_FORCE = 0;
    public static int SCRIBE_CAN_FORCE = 1;
    public static int ALL_AGREED = 2;
    static /* synthetic */ Class class$com$webmcq$ld$tool$groupreport$ReportBean;

    public abstract int getSid();

    public abstract void setSid(int var1);

    public abstract long getTaskInstanceId();

    public abstract void setTaskInstanceId(long var1);

    public abstract String getGroupName();

    public abstract void setGroupName(String var1);

    public abstract String getTitle();

    public abstract void setTitle(String var1);

    public abstract boolean getAdvancedMode();

    public abstract void setAdvancedMode(boolean var1);

    public abstract int getMinNumberToAgree();

    public abstract void setMinNumberToAgree(int var1);

    public abstract int getCurrentAgreementLevel();

    public abstract void setCurrentAgreementLevel(int var1);

    public void addAgreedMember(long userId) {
        if (this.getCompletionStatus() == COMPLETE) {
            return;
        }
        Collection members = this.getReportLearners();
        if (members != null) {
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                ReportLearnerLocal learner = (ReportLearnerLocal)iter.next();
                if (learner.getUserId() != userId) continue;
                learner.setAgreed(ReportLearnerBean.VOTE_AGREED);
                this.getLearnersAgreed().add(learner);
                this.getLearnersDisagreed().remove(learner);
            }
        }
        this.checkAgreementLevel();
    }

    public void addDisagreedMember(long userId) {
        if (this.isComplete()) {
            return;
        }
        Collection members = this.getReportLearners();
        if (members != null) {
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                ReportLearnerLocal learner = (ReportLearnerLocal)iter.next();
                if (learner.getUserId() != userId) continue;
                learner.setAgreed(ReportLearnerBean.VOTE_DISAGREED);
                this.getLearnersAgreed().remove(learner);
                this.getLearnersDisagreed().add(learner);
            }
        }
        this.checkAgreementLevel();
    }

    public void clearIndividualMemberAgreement(long userId) {
        if (this.isComplete()) {
            return;
        }
        Collection members = this.getReportLearners();
        if (members != null) {
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                ReportLearnerLocal learner = (ReportLearnerLocal)iter.next();
                if (learner.getUserId() != userId) continue;
                learner.setAgreed(ReportLearnerBean.VOTE_NOVOTE);
                this.getLearnersAgreed().remove(learner);
                this.getLearnersDisagreed().remove(learner);
            }
        }
        this.checkAgreementLevel();
    }

    public void clearAllMemberAgreement() {
        if (this.isComplete()) {
            return;
        }
        Collection members = this.getReportLearners();
        if (members != null) {
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                ReportLearnerLocal learner = (ReportLearnerLocal)iter.next();
                learner.setAgreed(ReportLearnerBean.VOTE_NOVOTE);
            }
        }
        this.getLearnersAgreed().clear();
        this.getLearnersDisagreed().clear();
        this.setCurrentAgreementLevel(SCRIBE_CANNOT_FORCE);
    }

    private void checkAgreementLevel() {
        int numAgreed = 0;
        int numDisagreed = 0;
        Collection members = this.getReportLearners();
        if (members != null) {
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                ReportLearnerLocal learner = (ReportLearnerLocal)iter.next();
                if (learner.getAgreed() == ReportLearnerBean.VOTE_AGREED) {
                    ++numAgreed;
                    continue;
                }
                if (learner.getAgreed() != ReportLearnerBean.VOTE_DISAGREED) continue;
                ++numDisagreed;
            }
        }
        if (numAgreed == members.size()) {
            this.setCurrentAgreementLevel(ALL_AGREED);
            log.debug((Object)"Setting report to completed as all are now agreed");
            this.createAgreementSummary(numAgreed, numDisagreed, members.size());
            this.setCompletionStatus(COMPLETE);
        } else if (numAgreed >= this.getMinNumberToAgree()) {
            this.setCurrentAgreementLevel(SCRIBE_CAN_FORCE);
        } else {
            this.setCurrentAgreementLevel(SCRIBE_CANNOT_FORCE);
        }
    }

    private void createAgreementSummary(int numAgreed, int numDisagreed, int numMembers) {
        ReportItemLocal reportItem;
        try {
            reportItem = ReportItemUtil.getLocalHome().create();
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        reportItem.setTaskInstanceId(this.getTaskInstanceId());
        reportItem.setHeading("");
        if (numAgreed == numMembers) {
            reportItem.setBody("All members agreed to this text.");
        } else if (this.getAdvancedMode()) {
            StringBuffer result = new StringBuffer(150);
            result.append(numAgreed);
            result.append(" group members agreed with this text, ");
            result.append(numDisagreed);
            result.append(" group members disagreed with this text, and ");
            result.append(numMembers - numAgreed - numDisagreed);
            result.append(" did not vote on this text.");
            reportItem.setBody(result.toString());
        } else {
            StringBuffer result = new StringBuffer(150);
            result.append(numAgreed);
            result.append(" out of ");
            result.append(numMembers);
            result.append(" group members agreed with this text");
            reportItem.setBody(result.toString());
        }
        log.debug((Object)("Created new report item for summary" + reportItem.getBody()));
        this.getReportItems().add(reportItem);
    }

    public boolean forceCompletion(long userid) {
        if (this.isComplete()) {
            log.error((Object)("Unable to force complete reporting task, instance id " + this.getTaskInstanceId() + " as the task is already complete. Report Info:" + this.getData().toString()));
            return false;
        }
        if (this.getCompletionStatus() != SCRIBE_CAN_FORCE) {
            log.error((Object)("Unable to force complete reporting task, instance id " + this.getTaskInstanceId() + " as the task is not in Scribe Can Force state. Report Info:" + this.getData().toString()));
            return false;
        }
        log.debug((Object)("Comparing scribe, getScribeUserId returns " + this.getScribeUserId() + " long value is " + this.getScribeUserId() + "passed in value is " + userid));
        if (this.getScribeUserId() == null || this.getScribeUserId() != userid) {
            log.error((Object)("Unable to force complete reporting task, instance id " + this.getTaskInstanceId() + " as the user id given " + userid + " is not the scribe. Report Info:" + this.getData().toString()));
            return false;
        }
        int numAgreed = 0;
        int numDisagreed = 0;
        Collection members = this.getReportLearners();
        if (members != null) {
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                ReportLearnerLocal learner = (ReportLearnerLocal)iter.next();
                if (learner.getAgreed() == ReportLearnerBean.VOTE_AGREED) {
                    ++numAgreed;
                    continue;
                }
                if (learner.getAgreed() != ReportLearnerBean.VOTE_DISAGREED) continue;
                ++numDisagreed;
            }
        }
        this.createAgreementSummary(numAgreed, numDisagreed, members.size());
        this.setCompletionStatus(COMPLETE);
        return true;
    }

    public abstract Collection getReportItems();

    public abstract void setReportItems(Collection var1);

    public abstract Collection getReportLearners();

    public abstract void setReportLearners(Collection var1);

    public void addReportLearner(ReportLearnerLocal learner) {
        this.getReportLearners().add(learner);
    }

    public abstract Collection getLearnersAgreed();

    public abstract void setLearnersAgreed(Collection var1);

    public int getNumAgreed() {
        return this.getLearnersAgreed().size();
    }

    public abstract Collection getLearnersDisagreed();

    public abstract void setLearnersDisagreed(Collection var1);

    public int getNumDisagreed() {
        return this.getLearnersDisagreed().size();
    }

    public ReportPK ejbCreate() throws CreateException {
        this.setSid(this.nextId());
        this.setCompletionStatus(INPROGRESS);
        return null;
    }

    public void ejbPostCreate() {
    }

    public abstract ReportData getData();

    public abstract int getCompletionStatus();

    public abstract void setCompletionStatus(int var1);

    public boolean isComplete() {
        return this.getCompletionStatus() == COMPLETE;
    }

    public abstract Long getScribeUserId();

    public abstract void setScribeUserId(Long var1);

    public abstract String getScribeUsername();

    public abstract void setScribeUsername(String var1);

    public void setScribe(long userid) {
        Collection members = this.getReportLearners();
        if (members != null) {
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                ReportLearnerLocal learner = (ReportLearnerLocal)iter.next();
                if (learner.getUserId() != userid) continue;
                this.setScribeUserId(new Long(userid));
                this.setScribeUsername(learner.getUsername());
            }
        }
    }

    public boolean isGroupMember(long userid) {
        Collection members = this.getReportLearners();
        if (members != null) {
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                ReportLearnerLocal learner = (ReportLearnerLocal)iter.next();
                if (learner.getUserId() != userid) continue;
                return true;
            }
        }
        return false;
    }

    public abstract Long getOutputContentId();

    public abstract void setOutputContentId(Long var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

