/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.mb.web;

import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.mb.MBMessageVO;
import com.webmcq.ld.tool.mb.MBServiceDAO;
import com.webmcq.ld.tool.mb.MBThreadVO;
import com.webmcq.ld.tool.mb.web.MBMessageForm;
import com.webmcq.ld.tool.mb.web.MBThreadForm;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MBThreadAction
extends ToolAction {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$mb$web$MBThreadAction == null ? (class$com$webmcq$ld$tool$mb$web$MBThreadAction = MBThreadAction.class$("com.webmcq.ld.tool.mb.web.MBThreadAction")) : class$com$webmcq$ld$tool$mb$web$MBThreadAction));
    public static final String START_MESSAGE = "startmessage";
    public static final String MESSAGE = "message";
    public static final String SUBJECT = "subject";
    public static final int MAX_SHORT_MESSAGE_LENGTH = 40;
    public static final int THREAD_MODE_MULTIPLE = 0;
    public static final int THREAD_MODE_SINGLE = 1;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm:ss a 'on' dd-MMM-yyyy");
    static /* synthetic */ Class class$com$webmcq$ld$tool$mb$web$MBThreadAction;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward getThread(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        ActionForward actionForward;
        MBServiceDAO mbServiceDAO = null;
        try {
            try {
                log.debug((Object)"getThread");
                HttpSession session = req.getSession(false);
                if (session == null) {
                    log.error((Object)"HttpSession does not exist");
                    throw new SystemException("HttpSession does not exist");
                }
                if (form == null) {
                    log.debug((Object)"MBThreadForm is null");
                    throw new SystemException("MBThreadForm is null");
                }
                MBThreadForm threadForm = (MBThreadForm)form;
                if (req.getParameter("messageId") == null || req.getParameter("messageId").trim().equals("")) {
                    threadForm.setMessageId(0L);
                }
                if (threadForm.getThreadId() <= 0L) {
                    log.error((Object)"threadId not found");
                    throw new SystemException("threadId not found");
                }
                mbServiceDAO = new MBServiceDAO(new PersistenceSession());
                MBThreadVO thread = mbServiceDAO.getThread((Long)session.getAttribute("MBForumId"), threadForm.getThreadId());
                int numOfUnreadMessages = thread.getMessages().size();
                if (numOfUnreadMessages > 0) {
                    boolean viewMode = this.isViewMode(session);
                    if (threadForm.getThreadMode() == 1) {
                        if (threadForm.getMessageId() == 0L) {
                            threadForm.setMessageId(thread.getStarterMessage());
                        }
                        threadForm.setMessageBoardContent(this.generateHTML(this.generateXML(thread, threadForm.getMessageId()), viewMode));
                        threadForm.setMessageBoardContentPreview(this.generatePreviewHTML(this.generateXML(thread)));
                    } else {
                        Document doc = this.generateXML(thread);
                        threadForm.setMessageBoardContent(this.generateHTML(doc, viewMode));
                        threadForm.setMessageBoardContentPreview(this.generatePreviewHTML(doc));
                    }
                } else {
                    log.debug((Object)("no messages in thread: " + thread.getSid()));
                    threadForm.setMessageBoardContent(null);
                    threadForm.setMessageBoardContentPreview(null);
                }
                String attributeName = mapping.getAttribute();
                if ("request".equals(mapping.getScope())) {
                    req.setAttribute(attributeName, (Object)threadForm);
                } else {
                    session.setAttribute(attributeName, (Object)threadForm);
                }
                log.debug((Object)("mapping topic to: " + attributeName));
                WebUtil.saveToken(req, "transactionKeyMessageBoard", this.generateToken(req));
                ActionForward dest = mapping.findForward("thread");
                log.debug((Object)("going to: " + dest.getPath()));
                actionForward = dest;
                Object var14_15 = null;
                if (mbServiceDAO == null) return actionForward;
            }
            catch (Exception e) {
                throw new SystemException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (mbServiceDAO == null) throw throwable;
            try {
                mbServiceDAO.disconnect();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return actionForward;
        }
        mbServiceDAO.disconnect();
        return actionForward;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward getSingleThread(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        ActionForward actionForward;
        MBServiceDAO mbServiceDAO = null;
        try {
            try {
                log.debug((Object)"getThread");
                HttpSession session = req.getSession(false);
                if (session == null) {
                    log.error((Object)"HttpSession does not exist");
                    throw new SystemException("HttpSession does not exist");
                }
                MBThreadForm threadForm = (MBThreadForm)form;
                if (threadForm.getThreadId() <= 0L) {
                    log.error((Object)"threadId not found");
                    throw new SystemException("threadId not found");
                }
                threadForm.setThreadMode(1);
                mbServiceDAO = new MBServiceDAO(new PersistenceSession());
                MBThreadVO thread = mbServiceDAO.getThread((Long)session.getAttribute("MBForumId"), threadForm.getThreadId());
                if (threadForm.getMessageId() == 0L) {
                    threadForm.setMessageId(thread.getStarterMessage());
                }
                int numOfUnreadMessages = thread.getMessages().size();
                boolean viewMode = this.isViewMode(session);
                if (numOfUnreadMessages > 0) {
                    threadForm.setMessageBoardContent(this.generateHTML(this.generateXML(thread, threadForm.getMessageId()), viewMode));
                    threadForm.setMessageBoardContentPreview(this.generatePreviewHTML(this.generateXML(thread)));
                } else {
                    log.debug((Object)("no messages in thread: " + thread.getSid()));
                    threadForm.setMessageBoardContent(null);
                    threadForm.setMessageBoardContentPreview(null);
                }
                String attributeName = mapping.getAttribute();
                if ("request".equals(mapping.getScope())) {
                    req.setAttribute(attributeName, (Object)threadForm);
                } else {
                    session.setAttribute(attributeName, (Object)threadForm);
                }
                log.debug((Object)("mapping topic to: " + attributeName));
                WebUtil.saveToken(req, "transactionKeyMessageBoard", this.generateToken(req));
                ActionForward dest = mapping.findForward("thread");
                log.debug((Object)("going to: " + dest.getPath()));
                actionForward = dest;
                Object var15_15 = null;
                if (mbServiceDAO == null) return actionForward;
            }
            catch (Exception e) {
                throw new SystemException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (mbServiceDAO == null) throw throwable;
            try {
                mbServiceDAO.disconnect();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return actionForward;
        }
        mbServiceDAO.disconnect();
        return actionForward;
    }

    private boolean isViewMode(HttpSession session) {
        boolean viewMode = false;
        if (session.getAttribute("mode") != null && session.getAttribute("reusable") != null && "view".equals((String)session.getAttribute("mode")) && "false".equals((String)session.getAttribute("reusable"))) {
            viewMode = true;
        }
        return viewMode;
    }

    public ActionForward newThread(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"newThread");
            HttpSession session = req.getSession(false);
            if (session == null) {
                log.error((Object)"HttpSession does not exist");
                throw new SystemException("HttpSession does not exist");
            }
            MBThreadForm threadForm = (MBThreadForm)form;
            String username = WebUtil.getUsername(req);
            ShwaaUserData user = UserServiceDelegate.find(username);
            long userId = user.getUid();
            log.debug((Object)("userId: " + userId));
            String fullName = user.getFirstName() + " " + user.getLastName();
            log.debug((Object)("fullName: " + fullName));
            MBMessageForm messageForm = new MBMessageForm();
            messageForm.setAuthorId(userId);
            messageForm.setAuthorName(fullName);
            messageForm.setThreadId(-1L);
            BeanUtils.copyProperties((Object)((Object)threadForm), (Object)((Object)messageForm));
            threadForm.setSid("-1");
            threadForm.setStarterMessage(messageForm);
            String attributeName = mapping.getAttribute();
            if ("request".equals(mapping.getScope())) {
                req.setAttribute(attributeName, (Object)threadForm);
            } else {
                session.setAttribute(attributeName, (Object)threadForm);
            }
            log.debug((Object)("mapping topic to: " + attributeName));
            ActionForward dest = mapping.findForward("newThread");
            log.debug((Object)("going to: " + dest.getPath()));
            return dest;
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward addThread(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        ActionForward actionForward;
        MBServiceDAO mbServiceDAO = null;
        try {
            try {
                log.debug((Object)"addThread");
                HttpSession session = req.getSession(false);
                if (session == null) {
                    log.error((Object)"HttpSession does not exist");
                    throw new SystemException("HttpSession does not exist");
                }
                String username = WebUtil.getUsername(req);
                ShwaaUserData user = UserServiceDelegate.find(username);
                MBThreadForm threadForm = (MBThreadForm)form;
                if (threadForm.getStarterMessage() != null && threadForm.getStarterMessage().getSubject() != null && !threadForm.getStarterMessage().getSubject().trim().equals("")) {
                    MBThreadVO thread = new MBThreadVO();
                    MBMessageVO message = new MBMessageVO();
                    thread.setForumId((Long)session.getAttribute("MBForumId"));
                    thread.setAuthorId(user.getUid());
                    thread.setAuthorName(user.getFirstName() + " " + user.getLastName());
                    thread.setSubject(threadForm.getStarterMessage().getSubject());
                    thread.setDateCreated(new Date());
                    message.setParentId(new Long(0L));
                    message.setAuthorId(thread.getAuthorId());
                    message.setSubject(threadForm.getStarterMessage().getSubject());
                    message.setAuthorName(thread.getAuthorName());
                    message.setBodyText(threadForm.getStarterMessage().getBodyText());
                    message.setPostDate(new Date());
                    mbServiceDAO = new MBServiceDAO(new PersistenceSession());
                    mbServiceDAO.addThread(thread);
                    message.setThreadId(thread.getSid());
                    mbServiceDAO.addMessage(message);
                    thread.setStarterMessage(message.getSid());
                    thread.setNumOfMessages(new Integer(1));
                    thread.setDateLastPosted(new Date());
                    mbServiceDAO.saveOrUpdate(thread);
                } else {
                    log.error((Object)"You must enter a Topic subject to add a Topic");
                }
                ActionForward dest = mapping.findForward("refreshForum");
                log.debug((Object)("going to: " + dest.getPath()));
                actionForward = dest;
                Object var13_13 = null;
                if (mbServiceDAO == null) return actionForward;
            }
            catch (Exception e) {
                throw new SystemException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (mbServiceDAO == null) throw throwable;
            try {
                mbServiceDAO.disconnect();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return actionForward;
        }
        mbServiceDAO.disconnect();
        return actionForward;
    }

    private String generatePreviewHTML(Document doc) {
        ByteArrayOutputStream out = null;
        try {
            DOMSource xmlSource = new DOMSource(doc);
            String xslFileName = "com/webmcq/ld/tool/mb/web/MBTransformPreview.xsl";
            InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(xslFileName);
            StreamSource xsltSource = new StreamSource(in);
            out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            Transformer xformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            xformer.transform(xmlSource, result);
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)e.toString(), (Throwable)e);
            return null;
        }
        catch (TransformerException e) {
            log.error((Object)e.toString(), (Throwable)e);
            return null;
        }
        return out.toString();
    }

    private String generateHTML(Document doc, boolean viewMode) {
        ByteArrayOutputStream out = null;
        try {
            DOMSource xmlSource = new DOMSource(doc);
            String xslFileName = viewMode ? "com/webmcq/ld/tool/mb/web/MBTransformViewMode.xsl" : "com/webmcq/ld/tool/mb/web/MBTransform.xsl";
            InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(xslFileName);
            StreamSource xsltSource = new StreamSource(in);
            out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            Transformer xformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            xformer.transform(xmlSource, result);
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)e.toString(), (Throwable)e);
            return null;
        }
        catch (TransformerException e) {
            log.error((Object)e.toString(), (Throwable)e);
            return null;
        }
        return out.toString();
    }

    private Document generateXML(MBThreadVO thread) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Set messages = thread.getMessages();
            Element root = doc.createElement(SUBJECT);
            root.setAttribute("authorname", thread.getAuthorName());
            root.setAttribute("postdate", this.dateToString(thread.getDateCreated()));
            root.setAttribute(SUBJECT, thread.getSubject());
            root.setAttribute("threadId", thread.getSid().toString());
            root.setAttribute("messageId", thread.getStarterMessage().toString());
            doc.appendChild(root);
            boolean foundRootNode = false;
            Element starterMessage = null;
            Iterator iMessages = messages.iterator();
            log.debug((Object)("# Start Messages: " + messages.size()));
            while (iMessages.hasNext()) {
                MBMessageVO messageVO = (MBMessageVO)iMessages.next();
                if (messageVO.getSid().longValue() != thread.getStarterMessage().longValue()) continue;
                starterMessage = doc.createElement(START_MESSAGE);
                starterMessage.setAttribute("sid", messageVO.getSid().toString());
                starterMessage.setAttribute(MESSAGE, messageVO.getBodyText());
                starterMessage.setAttribute("shortmessage", this.truncateString(messageVO.getBodyText(), 40));
                starterMessage.setAttribute("authorname", messageVO.getAuthorName());
                starterMessage.setAttribute("noofreplies", this.integerToString(messageVO.getNumOfReplies()));
                starterMessage.setAttribute("postdate", this.dateToString(messageVO.getPostDate()));
                root.appendChild(starterMessage);
                iMessages.remove();
                foundRootNode = true;
                break;
            }
            int sanityCount = 0;
            if (foundRootNode) {
                log.debug((Object)"Found root node");
                while (messages.size() > 0 && sanityCount < 100) {
                    ++sanityCount;
                    log.debug((Object)("Messages: " + messages.size()));
                    iMessages = messages.iterator();
                    block4: while (iMessages.hasNext()) {
                        MBMessageVO messageVO = (MBMessageVO)iMessages.next();
                        log.debug((Object)("MBMessageVO: " + messageVO.getParentId()));
                        if (messageVO.getParentId().longValue() == thread.getStarterMessage().longValue()) {
                            log.debug((Object)("Found parent: " + messageVO.getParentId()));
                            Element message = doc.createElement(MESSAGE);
                            message.setAttribute("sid", messageVO.getSid().toString());
                            message.setAttribute("parent", messageVO.getParentId().toString());
                            message.setAttribute(MESSAGE, messageVO.getBodyText());
                            message.setAttribute("shortmessage", this.truncateString(messageVO.getBodyText(), 40));
                            message.setAttribute("authorname", messageVO.getAuthorName());
                            message.setAttribute("noofreplies", this.integerToString(messageVO.getNumOfReplies()));
                            message.setAttribute("postdate", this.dateToString(messageVO.getPostDate()));
                            starterMessage.appendChild(message);
                            iMessages.remove();
                            continue;
                        }
                        NodeList currentMessages = doc.getElementsByTagName(MESSAGE);
                        for (int i = 0; i < currentMessages.getLength(); ++i) {
                            Element currentMessage = (Element)currentMessages.item(i);
                            log.debug((Object)("Looking for parent: " + currentMessage.getAttribute("sid") + " MBMessageVO.getParentId: " + messageVO.getParentId()));
                            if (!currentMessage.getAttribute("sid").equals(messageVO.getParentId().toString())) continue;
                            log.debug((Object)("Found parent: " + currentMessage.getAttribute("sid")));
                            Element message = doc.createElement(MESSAGE);
                            message.setAttribute("sid", messageVO.getSid().toString());
                            message.setAttribute("parent", messageVO.getParentId().toString());
                            message.setAttribute(MESSAGE, messageVO.getBodyText());
                            message.setAttribute("shortmessage", this.truncateString(messageVO.getBodyText(), 40));
                            message.setAttribute("authorname", messageVO.getAuthorName());
                            message.setAttribute("noofreplies", this.integerToString(messageVO.getNumOfReplies()));
                            message.setAttribute("postdate", this.dateToString(messageVO.getPostDate()));
                            currentMessage.appendChild(message);
                            iMessages.remove();
                            continue block4;
                        }
                    }
                }
            } else {
                log.error((Object)"Did not find root node");
            }
            log.debug((Object)("sanityCount: " + sanityCount));
            return doc;
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            return null;
        }
    }

    private Document generateXML(MBThreadVO thread, long selectedMessageId) {
        try {
            MBMessageVO messageVO;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Set messages = thread.getMessages();
            Element root = doc.createElement(SUBJECT);
            root.setAttribute("authorname", thread.getAuthorName());
            root.setAttribute("postdate", this.dateToString(thread.getDateCreated()));
            root.setAttribute(SUBJECT, thread.getSubject());
            root.setAttribute("threadId", thread.getSid().toString());
            root.setAttribute("messageId", thread.getStarterMessage().toString());
            doc.appendChild(root);
            Element starterMessage = null;
            Iterator iMessages = messages.iterator();
            log.debug((Object)("# Start Messages: " + messages.size()));
            while (iMessages.hasNext()) {
                messageVO = (MBMessageVO)iMessages.next();
                if (messageVO.getSid().longValue() != thread.getStarterMessage().longValue()) continue;
                starterMessage = doc.createElement(START_MESSAGE);
                starterMessage.setAttribute("sid", messageVO.getSid().toString());
                starterMessage.setAttribute(MESSAGE, messageVO.getBodyText());
                starterMessage.setAttribute("shortmessage", this.truncateString(messageVO.getBodyText(), 40));
                starterMessage.setAttribute("authorname", messageVO.getAuthorName());
                starterMessage.setAttribute("noofreplies", this.integerToString(messageVO.getNumOfReplies()));
                starterMessage.setAttribute("postdate", this.dateToString(messageVO.getPostDate()));
                root.appendChild(starterMessage);
                break;
            }
            if (selectedMessageId != thread.getStarterMessage()) {
                iMessages = messages.iterator();
                log.debug((Object)("# Start Messages: " + messages.size()));
                while (iMessages.hasNext()) {
                    messageVO = (MBMessageVO)iMessages.next();
                    if (messageVO.getSid() != selectedMessageId) continue;
                    Element message = doc.createElement(MESSAGE);
                    message.setAttribute("sid", messageVO.getSid().toString());
                    message.setAttribute(MESSAGE, messageVO.getBodyText());
                    message.setAttribute("shortmessage", this.truncateString(messageVO.getBodyText(), 40));
                    message.setAttribute("authorname", messageVO.getAuthorName());
                    message.setAttribute("noofreplies", this.integerToString(messageVO.getNumOfReplies()));
                    message.setAttribute("postdate", this.dateToString(messageVO.getPostDate()));
                    starterMessage.appendChild(message);
                    break;
                }
            }
            return doc;
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            return null;
        }
    }

    private String integerToString(Integer intValue) {
        if (intValue != null) {
            return intValue.toString();
        }
        return "0";
    }

    private String truncateString(String str, int size) {
        if (str.length() > size) {
            return str.substring(0, size) + "...";
        }
        return str;
    }

    private String dateToString(Date date) {
        if (date != null) {
            return this.dateFormat.format(date);
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

