/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.simpleassessment.dto;

import com.webmcq.ld.tool.simpleassessment.dto.AnswerComparableData;
import com.webmcq.ld.tool.simpleassessment.dto.AttemptData;
import com.webmcq.ld.tool.simpleassessment.dto.DisplayOrderComparator;
import com.webmcq.ld.tool.simpleassessment.dto.MarkData;
import com.webmcq.ld.tool.simpleassessment.dto.MarkSummaryData;
import com.webmcq.ld.tool.simpleassessment.dto.QuestionComparableData;
import com.webmcq.ld.tool.simpleassessment.interfaces.AnswerLocal;
import com.webmcq.ld.tool.simpleassessment.interfaces.LearnerAttemptLocal;
import com.webmcq.ld.tool.simpleassessment.interfaces.QuestionInfoData;
import com.webmcq.ld.tool.simpleassessment.interfaces.QuestionInfoLocal;
import com.webmcq.ld.tool.simpleassessment.interfaces.QuestionLocal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.log4j.Logger;

public class SimpleAssessmentDTOFactory {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$simpleassessment$dto$SimpleAssessmentDTOFactory == null ? (class$com$webmcq$ld$tool$simpleassessment$dto$SimpleAssessmentDTOFactory = SimpleAssessmentDTOFactory.class$("com.webmcq.ld.tool.simpleassessment.dto.SimpleAssessmentDTOFactory")) : class$com$webmcq$ld$tool$simpleassessment$dto$SimpleAssessmentDTOFactory));
    static /* synthetic */ Class class$com$webmcq$ld$tool$simpleassessment$dto$SimpleAssessmentDTOFactory;

    public static QuestionInfoData getQuestionInfo(QuestionInfoLocal questionInfo) {
        if (questionInfo != null) {
            return questionInfo.getData();
        }
        return null;
    }

    public static Map getQuestionMap(QuestionInfoLocal questionInfo) {
        if (questionInfo != null) {
            HashMap<Integer, QuestionComparableData> dataMap = new HashMap<Integer, QuestionComparableData>();
            Iterator iter = questionInfo.getQuestions().iterator();
            while (iter.hasNext()) {
                QuestionLocal element = (QuestionLocal)iter.next();
                dataMap.put(new Integer(element.getSid()), SimpleAssessmentDTOFactory.getQuestion(element));
            }
            return dataMap;
        }
        return null;
    }

    public static SortedSet getQuestionSortedSet(QuestionInfoLocal questionInfo) {
        if (questionInfo != null) {
            TreeSet<QuestionComparableData> dataSet = new TreeSet<QuestionComparableData>(new DisplayOrderComparator());
            Iterator iter = questionInfo.getQuestions().iterator();
            while (iter.hasNext()) {
                QuestionLocal element = (QuestionLocal)iter.next();
                dataSet.add(SimpleAssessmentDTOFactory.getQuestion(element));
            }
            return dataSet;
        }
        return null;
    }

    public static QuestionComparableData getQuestion(QuestionLocal question) {
        QuestionComparableData data = new QuestionComparableData();
        if (question != null) {
            data.setSid(question.getSid());
            data.setFeedback(question.getFeedback() != null ? question.getFeedback() : "");
            data.setQuestion(question.getQuestion() != null ? question.getQuestion() : "");
            data.setDisplayOrder(question.getDisplayOrder());
            TreeSet<AnswerComparableData> answers = new TreeSet<AnswerComparableData>(new DisplayOrderComparator());
            Iterator iter = question.getPossibleAnswers().iterator();
            while (iter.hasNext()) {
                AnswerLocal answer = (AnswerLocal)iter.next();
                answers.add(SimpleAssessmentDTOFactory.getAnswer(answer));
            }
            data.setAnswers(answers);
        }
        return data;
    }

    public static AnswerComparableData getAnswer(AnswerLocal answer) {
        AnswerComparableData data = new AnswerComparableData();
        if (answer != null) {
            data.setAnswer(answer.getAnswer() != null ? answer.getAnswer() : "");
            data.setCorrect(answer.getCorrect());
            data.setDisplayOrder(answer.getDisplayOrder());
            data.setLearnerQuestionSid(answer.getLearnerQuestionSid());
            data.setSid(answer.getSid());
        }
        return data;
    }

    public static AttemptData getAttempt(LearnerAttemptLocal attemptInfo) {
        if (attemptInfo != null) {
            TreeSet<AnswerComparableData> dataSet = new TreeSet<AnswerComparableData>(new DisplayOrderComparator());
            Iterator iter = attemptInfo.getAnswers().iterator();
            while (iter.hasNext()) {
                AnswerLocal element = (AnswerLocal)iter.next();
                dataSet.add(SimpleAssessmentDTOFactory.getAnswer(element));
            }
            AttemptData attempt = new AttemptData(attemptInfo.getSid(), attemptInfo.getUserId(), attemptInfo.getUsername(), attemptInfo.getMark() != null ? attemptInfo.getMark() : new Integer(0), attemptInfo.getAttemptCount(), attemptInfo.getSubmittedDate(), dataSet);
            return attempt;
        }
        return null;
    }

    public static MarkSummaryData getMarkSummary(QuestionInfoLocal qsInfo, boolean includeIndividualMarks) {
        if (qsInfo != null) {
            TreeMap<String, TreeMap<Integer, MarkData>> sortedUserMap = null;
            Integer maxAttempts = null;
            if (includeIndividualMarks) {
                sortedUserMap = new TreeMap<String, TreeMap<Integer, MarkData>>();
                Iterator iter = qsInfo.getLearnerAttemptIterator();
                int maxNumAttempts = 0;
                while (iter.hasNext()) {
                    LearnerAttemptLocal attempt = (LearnerAttemptLocal)iter.next();
                    String username = attempt.getUsername();
                    MarkData mark = SimpleAssessmentDTOFactory.getMark(attempt);
                    TreeMap<Integer, MarkData> markMap = (TreeMap<Integer, MarkData>)sortedUserMap.get(username);
                    if (markMap == null) {
                        markMap = new TreeMap<Integer, MarkData>((Comparator<Integer>)new ReverseComparator());
                        sortedUserMap.put(username, markMap);
                    }
                    markMap.put(new Integer(attempt.getAttemptCount()), mark);
                    maxNumAttempts = Math.max(maxNumAttempts, markMap.size());
                }
                maxAttempts = new Integer(maxNumAttempts);
            }
            return new MarkSummaryData(sortedUserMap, maxAttempts, qsInfo.getTotalMark() != null ? qsInfo.getTotalMark() : 0, qsInfo.getMaxMark(), qsInfo.getAverageMark(), qsInfo.getMinMark(), qsInfo.getNumLearnersAnswered());
        }
        return null;
    }

    private static MarkData getMark(LearnerAttemptLocal attempt) {
        if (attempt != null) {
            return new MarkData(attempt.getUserId(), attempt.getUsername(), attempt.getMark() != null ? attempt.getMark() : 0, attempt.getAttemptCount(), attempt.getSubmittedDate(), attempt.getIsBestAttempt());
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

