/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.urlcontent.web;

import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.filemanager.FileManagerDelegate;
import com.webmcq.ld.tool.filemanager.FileManagerException;
import com.webmcq.ld.tool.filemanager.IllegalFileException;
import com.webmcq.ld.tool.urlcontent.URLContentException;
import com.webmcq.ld.tool.urlcontent.dto.URLContentDTOFactory;
import com.webmcq.ld.tool.urlcontent.dto.URLData;
import com.webmcq.ld.tool.urlcontent.interfaces.URLContentData;
import com.webmcq.ld.tool.urlcontent.interfaces.URLContentService;
import com.webmcq.ld.tool.urlcontent.interfaces.URLContentServiceUtil;
import com.webmcq.ld.tool.urlcontent.interfaces.URLLearnerData;
import com.webmcq.ld.usermanagement.UserRole;
import com.webmcq.ld.util.UploadFileUtil;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class URLContentAction
extends ToolAction {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$urlcontent$web$URLContentAction == null ? (class$com$webmcq$ld$tool$urlcontent$web$URLContentAction = URLContentAction.class$("com.webmcq.ld.tool.urlcontent.web.URLContentAction")) : class$com$webmcq$ld$tool$urlcontent$web$URLContentAction));
    public static String ACTION_NAME = "urlcontent";
    public static String TOOL_PATH = "tool/urlcontent/";
    public static String JSP_SUBMIT_BUTTON_FINISH = "Finish";
    public static String JSP_SUBMIT_BUTTON_URL = "SubmitUrl";
    public static String JSP_SUBMIT_BUTTON_FILE_UPLOAD = "Upload";
    public static String JSP_SUBMIT_BUTTON_RESOURCE_UPLOAD = "UploadResource";
    public static String JSP_SUBMIT_FILE = "file";
    public static String JSP_SUBMIT_NEWURL = "newUrl";
    public static String JSP_SUBMIT_NEWTITLE_URL = "newTitleUrl";
    public static String JSP_SUBMIT_NEWTITLE_FILE = "newTitleFile";
    public static String JSP_SUBMIT_NEWINSTRUCTION_URL = "newInstructionUrl";
    public static String JSP_SUBMIT_NEWINSTRUCTION_FILE = "newInstructionFile";
    public static String JSP_SUBMIT_DIRECTORY_NAME = "directoryName";
    public static String JSP_MAX_FILESIZE_TAG = "maxfilesize";
    public static String JSP_ERROR_TAG = "error";
    public static String JSP_TASK_INSTANCE_ID_TAG = "sessionId";
    public static String JSP_URL_ID_TAG = "urlId";
    public static String JSP_MODE_TAG = "mode";
    public static String JSP_LEARNER_USER_ID_TAG = "userId";
    public static String JSPINPUT_INFO_TAG = "info";
    public static String JSPINPUT_ERROR_TAG = "error";
    public static String JSPINPUT_UPDATE_PROGRESS_BAR_TAG = "updateProgressBar";
    public static String JSPINPUT_ACTOR_TAG = "actor";
    public static String JSPINPUT_ACTOR_LEARNER_TAG = "learner";
    public static String JSPINPUT_ACTOR_STAFF_TAG = "staff";
    public static String JSPINPUT_URLSET_TAG = "urlSet";
    public static String JSP_POPUP_TAG = "popup";
    public static String JSPINPUT_URLDATA_TAG = "urlData";
    public static String JSPINPUT_INSTRUCTION_NO_TAG = "instructionNo";
    public static String JSP_RESOURCE_PRESENT_TAG = "resourcePresent";
    public static String JSP_MANAGE_URL_DATA_TAG = "manageUrlData";
    protected static String defaultAccessMode = "run";
    protected static String URL_ENCODING = "UTF-8";
    public static final String URI_DIRECTORY = "urldirectory";
    public static final String JSP_STAFF_TAG = "staff";
    static /* synthetic */ Class class$com$webmcq$ld$tool$urlcontent$web$URLContentAction;

    public static String getStaffPath(long taskInstanceId) {
        return TOOL_PATH + "urlcontent.do?method=getStaffList&sessionId=" + taskInstanceId;
    }

    protected String getMode(String inputMode, HttpServletRequest req) {
        String mode;
        String objMode = req.getParameter(JSP_MODE_TAG);
        if (objMode == null) {
            objMode = (String)req.getAttribute(JSP_MODE_TAG);
        }
        String string = mode = inputMode != null ? inputMode : objMode;
        if (mode == null) {
            mode = defaultAccessMode;
        }
        log.debug((Object)("--> getMode : inputMode(" + inputMode + ") mode(" + mode + ")"));
        return mode;
    }

    protected long getUserId(HttpServletRequest req, String mode) throws ServletException {
        try {
            if ("checkup".equals(mode)) {
                return WebUtil.readLongParam(req, "userId");
            }
            return UserServiceDelegate.findUserId(WebUtil.getUsername(req));
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public String getToolPath() {
        return TOOL_PATH;
    }

    public String getActionName() {
        return ACTION_NAME;
    }

    protected ActionForward findFowardAfterUpload(ActionMapping mapping, HttpServletRequest req) {
        return mapping.findForward(this.getListFowardAction());
    }

    public String getListFowardAction() {
        return "list";
    }

    public String getContentFowardAction() {
        return "content";
    }

    public boolean getDefaultIsFileUrl() {
        return true;
    }

    protected boolean isStaff(HttpServletRequest req) throws ServletException {
        return JSPINPUT_ACTOR_STAFF_TAG.equals(req.getParameter(JSPINPUT_ACTOR_TAG));
    }

    public ActionForward getList(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.prepareList(req, false, null, null);
        WebUtil.saveToken(req, "transactionKeyUrlContent", this.generateToken(req));
        String mode = this.getMode(null, req);
        if (mode.equals("run") || mode.equals("resume")) {
            URLLearnerData learner = null;
            try {
                learner = this.getURLLearner(req);
            }
            catch (Exception e) {
                log.error((Object)("Request to access content occured but user " + WebUtil.getUsername(req) + " not entitled to share the resource"));
                req.setAttribute(JSP_ERROR_TAG, (Object)"You do not have access to this information");
                return mapping.findForward("error");
            }
            if (!req.isUserInRole(UserRole.STAFF.getName()) && learner == null) {
                log.error((Object)("Request to access content occured but user " + WebUtil.getUsername(req) + " not entitled to share the resource"));
                req.setAttribute(JSP_ERROR_TAG, (Object)"You do not have access to this information");
                return mapping.findForward("error");
            }
            req.setAttribute(JSPINPUT_UPDATE_PROGRESS_BAR_TAG, (Object)"true");
        } else {
            req.setAttribute(JSPINPUT_UPDATE_PROGRESS_BAR_TAG, (Object)"false");
        }
        return mapping.findForward(this.getListFowardAction());
    }

    public ActionForward getStaffList(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.prepareList(req, true, null, null);
        WebUtil.saveToken(req, "transactionKeyUrlContent", this.generateToken(req));
        return mapping.findForward(this.getListFowardAction());
    }

    protected void prepareList(HttpServletRequest req, boolean staff, String inputMode, String inputError) throws ServletException {
        try {
            HttpSession session;
            String taskSessionId = null;
            if (req.getParameter(JSP_TASK_INSTANCE_ID_TAG) != null) {
                taskSessionId = req.getParameter(JSP_TASK_INSTANCE_ID_TAG);
            }
            if ((session = req.getSession(false)) == null) {
                log.debug((Object)"HttpSession does not exist");
                throw new SystemException("HttpSession does not exist");
            }
            session.setAttribute(JSP_TASK_INSTANCE_ID_TAG, (Object)taskSessionId);
            if (staff) {
                session.setAttribute(JSP_STAFF_TAG, (Object)"true");
            } else {
                session.setAttribute(JSP_STAFF_TAG, (Object)"false");
            }
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            log.debug((Object)("prepareList taskInstanceId: " + taskInstanceId));
            String mode = this.getMode(inputMode, req);
            long userId = this.getUserId(req, mode);
            String exceptionError = null;
            URLContentService service = URLContentServiceUtil.getHome().create();
            URLContentData contentData = null;
            TreeSet urlSet = null;
            try {
                contentData = service.getGeneralInfo(taskInstanceId, userId);
                urlSet = service.getURLSet(taskInstanceId, userId);
            }
            catch (URLContentException e) {
                exceptionError = "Unable to create URL list due to error: " + e.getMessage();
            }
            log.debug((Object)("Info is " + contentData));
            log.debug((Object)("urlset is " + urlSet));
            log.debug((Object)("Mode is " + mode));
            log.debug((Object)("Error is " + inputError));
            String error = inputError;
            if (contentData == null || urlSet == null) {
                error = (error != null ? error : "") + (exceptionError != null ? exceptionError : "No information for this learner/task found");
                if (contentData == null) {
                    contentData = URLContentDTOFactory.createDummyURLContentData(taskInstanceId);
                }
                if (urlSet == null) {
                    urlSet = new TreeSet();
                }
            }
            if (urlSet.size() > 0) {
                req.setAttribute(JSP_RESOURCE_PRESENT_TAG, (Object)"true");
            } else {
                req.setAttribute(JSP_RESOURCE_PRESENT_TAG, (Object)"false");
            }
            req.setAttribute(JSPINPUT_ERROR_TAG, (Object)error);
            req.setAttribute(JSPINPUT_INFO_TAG, (Object)contentData);
            req.setAttribute(JSPINPUT_URLSET_TAG, (Object)urlSet);
            session.setAttribute(JSP_MODE_TAG, (Object)mode);
            if ("checkup".equals(mode)) {
                session.setAttribute(JSP_LEARNER_USER_ID_TAG, (Object)new Long(userId));
            }
            String actor = staff ? JSPINPUT_ACTOR_STAFF_TAG : JSPINPUT_ACTOR_LEARNER_TAG;
            session.setAttribute(JSPINPUT_ACTOR_TAG, (Object)actor);
            float maxFileSize = UploadFileUtil.getMaxFileSize();
            log.debug((Object)("Setting " + JSP_MAX_FILESIZE_TAG + " to " + Float.toString(maxFileSize)));
            req.setAttribute(JSP_MAX_FILESIZE_TAG, (Object)Float.toString(maxFileSize));
            service.remove();
        }
        catch (CreateException e) {
            log.error((Object)"CreateException thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            log.error((Object)"NamingException thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (RemoveException e) {
            log.error((Object)"RemoveException thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"Exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward setContentDone(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            int entryId = WebUtil.readIntParam(req, JSP_URL_ID_TAG);
            boolean staff = this.isStaff(req);
            log.debug((Object)("setContentDone:" + entryId));
            String username = null;
            username = WebUtil.getUsername(req);
            long userId = UserServiceDelegate.findUserId(username);
            String error = null;
            if (!staff) {
                URLContentService service = URLContentServiceUtil.getHome().create();
                try {
                    service.setEntryDone(taskInstanceId, userId, entryId);
                    service.remove();
                }
                catch (URLContentException e) {
                    error = "Unable to set URL to completed: " + e.getMessage();
                }
            }
            this.prepareList(req, staff, null, error);
            WebUtil.saveToken(req, "transactionKeyUrlContent", this.generateToken(req));
            req.setAttribute(JSPINPUT_UPDATE_PROGRESS_BAR_TAG, (Object)"false");
            return mapping.findForward(this.getListFowardAction());
        }
        catch (Exception e) {
            req.setAttribute(JSP_ERROR_TAG, (Object)e.getMessage());
            return mapping.findForward("error");
        }
    }

    public ActionForward getContent(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            this.prepareContent(req);
            return mapping.findForward(this.getContentFowardAction());
        }
        catch (Exception e) {
            req.setAttribute(JSP_ERROR_TAG, (Object)e.getMessage());
            return mapping.findForward("error");
        }
    }

    public ActionForward doListSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"doListSubmission");
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            String mode = this.getMode(null, req);
            boolean staff = this.isStaff(req);
            boolean doComplete = false;
            boolean doUpload = false;
            boolean doUrl = false;
            boolean doUploadResource = false;
            String submittedUrl = null;
            String submittedInstructionURL = null;
            String submittedInstructionFile = null;
            String submittedTitleURL = null;
            String submittedTitleFile = null;
            FileItem fileToUpload = null;
            String originalFilename = null;
            String tokenTransaction = null;
            String directoryName = null;
            String error = null;
            List items = null;
            try {
                items = UploadFileUtil.getUploadItems(req, false);
                Iterator iter = items.iterator();
                while (iter.hasNext()) {
                    FileItem item = (FileItem)iter.next();
                    log.debug((Object)("Request item: " + item.getFieldName()));
                    if (JSP_SUBMIT_NEWURL.equals(item.getFieldName())) {
                        submittedUrl = item.getString();
                        continue;
                    }
                    if (JSP_SUBMIT_NEWINSTRUCTION_URL.equals(item.getFieldName())) {
                        submittedInstructionURL = item.getString();
                        continue;
                    }
                    if (JSP_SUBMIT_DIRECTORY_NAME.equals(item.getFieldName())) {
                        directoryName = item.getString();
                        continue;
                    }
                    if (JSP_SUBMIT_NEWINSTRUCTION_FILE.equals(item.getFieldName())) {
                        submittedInstructionFile = item.getString();
                        continue;
                    }
                    if (JSP_SUBMIT_NEWTITLE_URL.equals(item.getFieldName())) {
                        submittedTitleURL = item.getString();
                        continue;
                    }
                    if (JSP_SUBMIT_NEWTITLE_FILE.equals(item.getFieldName())) {
                        submittedTitleFile = item.getString();
                        continue;
                    }
                    if (JSP_SUBMIT_BUTTON_FINISH.equals(item.getFieldName())) {
                        doComplete = true;
                        continue;
                    }
                    if (JSP_SUBMIT_BUTTON_FILE_UPLOAD.equals(item.getFieldName())) {
                        doUpload = true;
                        continue;
                    }
                    if (JSP_SUBMIT_BUTTON_URL.equals(item.getFieldName())) {
                        doUrl = true;
                        continue;
                    }
                    if (JSP_SUBMIT_BUTTON_RESOURCE_UPLOAD.equals(item.getFieldName())) {
                        doUploadResource = true;
                        continue;
                    }
                    if (JSP_SUBMIT_FILE.equals(item.getFieldName()) && item.getName() != null && item.getSize() != 0L) {
                        originalFilename = item.getName();
                        fileToUpload = item;
                        continue;
                    }
                    if (!"transactionKeyUrlContent".equals(item.getFieldName())) continue;
                    tokenTransaction = item.getString();
                }
            }
            catch (FileUploadException fue) {
                log.error((Object)("Unable to upload file taskInstanceId=" + taskInstanceId + ". Exception occured"), (Throwable)fue);
                error = "Unable to upload file. Error returned by uploader was:" + fue.getMessage();
            }
            req.setAttribute(JSPINPUT_UPDATE_PROGRESS_BAR_TAG, (Object)"false");
            if (error != null) {
                this.prepareList(req, staff, mode, error);
                WebUtil.saveToken(req, "transactionKeyUrlContent", this.generateToken(req));
                return mapping.findForward(this.getListFowardAction());
            }
            return this.processUploadFinish(mapping, req, taskInstanceId, staff, mode, doComplete, doUpload, doUrl, doUploadResource, submittedUrl, submittedInstructionURL, submittedTitleURL, submittedInstructionFile, submittedTitleFile, fileToUpload, originalFilename, directoryName, tokenTransaction);
        }
        catch (Exception e) {
            log.debug((Object)"Error occured", (Throwable)e);
            req.setAttribute(JSP_ERROR_TAG, (Object)e.getMessage());
            return mapping.findForward("error");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionForward processUploadFinish(ActionMapping mapping, HttpServletRequest req, int taskInstanceId, boolean staff, String mode, boolean doComplete, boolean doUpload, boolean doUrl, boolean doUploadResource, String submittedUrl, String submittedInstructionUrl, String submittedTitleUrl, String submittedInstructionFile, String submittedTitleFile, FileItem fileToUpload, String originalFilename, String directoryName, String tokenTransaction) {
        try {
            String tokenSessionTransaction = WebUtil.retrieveToken(req, "transactionKeyUrlContent");
            Object error = null;
            String username = WebUtil.getUsername(req);
            long userId = UserServiceDelegate.findUserId(username);
            String cleanUrl = StringUtils.trimToEmpty((String)submittedUrl);
            if (doComplete) {
                log.debug((Object)("tokenSessionTransaction : " + tokenSessionTransaction));
                log.debug((Object)("tokenTransaction        : " + tokenTransaction));
                if (tokenSessionTransaction == null || tokenTransaction == null) return this.duplicateSubmission(mapping, req, "transactionDoneUrlContent");
                if (!tokenSessionTransaction.equals(tokenTransaction)) return this.duplicateSubmission(mapping, req, "transactionDoneUrlContent");
                WebUtil.resetToken(req, "transactionKeyUrlContent");
                req.getSession().removeAttribute("transactionDoneUrlContent");
                error = this.processFinish(taskInstanceId, cleanUrl, fileToUpload, userId, staff);
                if (error == null || error instanceof DisplayTaskData) {
                    this.resetUrlSessionEntries(req.getSession());
                    ActionForward action = this.displayTask((DisplayTaskData)error, mapping, req);
                    req.getSession().setAttribute("transactionDoneUrlContent", (Object)action);
                    return action;
                }
            } else if (doUpload) {
                error = this.processFile(taskInstanceId, submittedInstructionFile, submittedTitleFile, fileToUpload, originalFilename, username, userId);
                if (error == null) {
                    this.resetUrlSessionEntries(req.getSession());
                }
            } else if (doUploadResource) {
                req.setAttribute(JSP_SUBMIT_DIRECTORY_NAME, (Object)directoryName);
                error = this.processResource(taskInstanceId, submittedInstructionFile, submittedTitleFile, fileToUpload, originalFilename, directoryName, username, userId);
                if (error == null) {
                    this.resetUrlSessionEntries(req.getSession());
                }
            } else if (doUrl) {
                error = this.processURL(taskInstanceId, cleanUrl, submittedInstructionUrl, submittedTitleUrl, username, userId);
                if (error == null) {
                    this.resetUrlSessionEntries(req.getSession());
                }
            } else {
                this.setUrlSessionEntries(req.getSession(), cleanUrl, submittedInstructionUrl, submittedTitleUrl, submittedInstructionFile, submittedTitleFile);
            }
            if (error != null && !(error instanceof DisplayTaskData)) {
                this.setUrlSessionEntries(req.getSession(), cleanUrl, submittedInstructionUrl, submittedTitleUrl, submittedInstructionFile, submittedTitleFile);
            }
            this.prepareList(req, staff, mode, (String)error);
            WebUtil.saveToken(req, "transactionKeyUrlContent", this.generateToken(req));
            return this.findFowardAfterUpload(mapping, req);
        }
        catch (Exception e) {
            log.debug((Object)"Error occured", (Throwable)e);
            req.setAttribute(JSP_ERROR_TAG, (Object)e.getMessage());
            return mapping.findForward("error");
        }
    }

    public String processURL(int taskInstanceId, String submittedUrl, String submittedUrlInstruction, String submittedTitle, String username, long userId) {
        String error = null;
        if (submittedUrl == null || submittedUrl.length() == 0 || submittedUrl.equals("http://")) {
            error = "Please enter a value in the url field before submitting";
        } else if (submittedTitle == null || submittedTitle.length() == 0) {
            error = "Please enter a value in the title field before submitting";
        } else {
            try {
                URLContentService service = URLContentServiceUtil.getHome().create();
                service.submitURL(taskInstanceId, userId, username, submittedUrl, submittedTitle, submittedUrlInstruction, false);
                service.remove();
            }
            catch (Exception e) {
                log.error((Object)"processURL:", (Throwable)e);
                error = "Error occured: " + e.getMessage();
            }
        }
        return error;
    }

    private Object processFinish(int taskInstanceId, String submittedUrl, FileItem fileToUpload, long userId, boolean staff) {
        String error = null;
        if (fileToUpload != null || submittedUrl != null && submittedUrl.length() != 0) {
            error = "Cannot finish with a url entered or file uploaded. To finish, please clear all the fields on the page first";
        } else if (staff) {
            error = "Cannot do finish while in staff view.";
        } else {
            log.debug((Object)"Attempting finish");
            try {
                URLContentService service = URLContentServiceUtil.getHome().create();
                DisplayTaskData displayTaskData = service.completeSession(taskInstanceId, userId);
                service.remove();
                return displayTaskData;
            }
            catch (Exception e) {
                log.error((Object)"processFinish:", (Throwable)e);
                error = "Error occured: " + e.getMessage();
            }
        }
        return error;
    }

    private String processFile(int taskInstanceId, String submittedUrlInstruction, String submittedTitle, FileItem fileToUpload, String originalFilename, String username, long userId) {
        if (fileToUpload == null) {
            return "No file supplied. Cannot upload.";
        }
        if (submittedTitle == null || submittedTitle.length() == 0) {
            return "Please enter a value in the title field before submitting";
        }
        String error = null;
        try {
            String lamsUrl = FileManagerDelegate.uploadFile(fileToUpload, originalFilename, new Integer(taskInstanceId), true, false, false);
            if (lamsUrl != null) {
                URLContentService service = URLContentServiceUtil.getHome().create();
                service.submitURL(taskInstanceId, userId, username, lamsUrl, submittedTitle, submittedUrlInstruction, this.getDefaultIsFileUrl());
                service.remove();
            } else {
                error = "No url returned by FileManager";
            }
        }
        catch (IllegalFileException e) {
            log.error((Object)("processFile: User " + username + " tried to upload an executable file " + originalFilename));
            error = "File appears to be an executable file. Upload not permitted.";
        }
        catch (FileManagerException e) {
            log.error((Object)"processFile: FileManagerException", (Throwable)e);
            error = e.getMessage();
        }
        catch (Throwable e) {
            log.error((Object)"processFile:", e);
            error = "Error occured: " + e.getMessage();
        }
        return error;
    }

    private String processResource(int taskInstanceId, String submittedUrlInstruction, String submittedTitle, FileItem fileToUpload, String originalFilename, String directoryName, String username, long userId) {
        if (fileToUpload == null) {
            return "No resource supplied. Cannot upload.";
        }
        if (submittedTitle == null || submittedTitle.length() == 0) {
            return "Please enter a value in the title field before submitting";
        }
        String error = null;
        try {
            String lamsUrl = FileManagerDelegate.uploadResource(fileToUpload, originalFilename, directoryName, new Integer(taskInstanceId), false);
            if (lamsUrl != null) {
                URLContentService service = URLContentServiceUtil.getHome().create();
                service.submitURL(taskInstanceId, userId, username, lamsUrl, submittedTitle, submittedUrlInstruction, this.getDefaultIsFileUrl());
                service.remove();
            } else {
                error = "No url returned by FileManager";
            }
        }
        catch (IllegalFileException e) {
            log.error((Object)("processResource: User " + username + " tried to upload an executable file " + originalFilename));
            error = "File appears to be an executable file. Upload not permitted.";
        }
        catch (FileManagerException e) {
            log.error((Object)"processResource: FileManagerException", (Throwable)e);
            error = e.getMessage();
        }
        catch (Throwable e) {
            log.error((Object)"processResource:", e);
            error = "Error occured: " + e.getMessage();
        }
        return error;
    }

    private void setUrlSessionEntries(HttpSession session, String submittedUrl, String submittedInstructionURL, String submittedTitleURL, String submittedInstructionFile, String submittedTitleFile) {
        session.setAttribute(JSP_SUBMIT_NEWURL, (Object)submittedUrl);
        session.setAttribute(JSP_SUBMIT_NEWINSTRUCTION_URL, (Object)submittedInstructionURL);
        session.setAttribute(JSP_SUBMIT_NEWTITLE_URL, (Object)submittedTitleURL);
        session.setAttribute(JSP_SUBMIT_NEWINSTRUCTION_FILE, (Object)submittedInstructionFile);
        session.setAttribute(JSP_SUBMIT_NEWTITLE_FILE, (Object)submittedTitleFile);
    }

    public void resetUrlSessionEntries(HttpSession session) {
        session.removeAttribute(JSP_SUBMIT_NEWURL);
        session.removeAttribute(JSP_SUBMIT_NEWINSTRUCTION_URL);
        session.removeAttribute(JSP_SUBMIT_NEWTITLE_URL);
        session.removeAttribute(JSP_SUBMIT_NEWINSTRUCTION_FILE);
        session.removeAttribute(JSP_SUBMIT_NEWTITLE_FILE);
    }

    private URLLearnerData getURLLearner(HttpServletRequest req) throws Exception {
        int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
        String username = WebUtil.getUsername(req);
        long userId = UserServiceDelegate.findUserId(username);
        URLContentService service = URLContentServiceUtil.getHome().create();
        return service.getLearner(taskInstanceId, userId);
    }

    public ActionForward getFrameset(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            URLLearnerData learner = this.getURLLearner(req);
            if (!req.isUserInRole(UserRole.STAFF.getName()) && learner == null) {
                log.error((Object)("Request to access content occured but user " + WebUtil.getUsername(req) + " not entitled to download files"));
                req.setAttribute(JSP_ERROR_TAG, (Object)"You do not have access to this information");
                return mapping.findForward("error");
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception thrown", (Throwable)e);
            req.setAttribute(JSP_ERROR_TAG, (Object)e.getMessage());
            return mapping.findForward("error");
        }
        String frameset = this.getFrameset(req, res, this.getToolPath(), this.getActionName(), "getContent");
        if (frameset == null) {
            WebUtil.saveToken(req, "transactionKeyUrlContent", this.generateToken(req));
            return mapping.findForward(this.getListFowardAction());
        }
        log.debug((Object)("Redirecting to " + frameset));
        res.sendRedirect(frameset.toString());
        return null;
    }

    public String getFrameset(HttpServletRequest req, HttpServletResponse res, String toolPath, String actionName, String actionMethodName) throws IOException, ServletException {
        try {
            String error;
            URLData urlData;
            URLContentData urlContentData;
            long userId;
            boolean staff;
            String mode;
            int taskInstanceId;
            int entryId;
            boolean manageUrlData;
            block13: {
                manageUrlData = true;
                Object urlId = req.getAttribute(JSP_URL_ID_TAG);
                entryId = urlId != null ? Integer.valueOf((String)urlId) : WebUtil.readIntParam(req, JSP_URL_ID_TAG);
                Object taskId = req.getAttribute(JSP_TASK_INSTANCE_ID_TAG);
                taskInstanceId = taskId != null ? Integer.valueOf((String)taskId) : WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
                Object manageData = req.getAttribute(JSP_MANAGE_URL_DATA_TAG);
                if (manageData != null) {
                    manageUrlData = Boolean.valueOf((String)manageData);
                }
                mode = this.getMode(null, req);
                staff = this.isStaff(req);
                userId = this.getUserId(req, mode);
                urlContentData = null;
                urlData = null;
                error = null;
                URLContentService service = URLContentServiceUtil.getHome().create();
                try {
                    urlContentData = service.getGeneralInfo(taskInstanceId, userId);
                    urlData = service.getURLDetails(taskInstanceId, userId, entryId, 0);
                    service.remove();
                }
                catch (URLContentException e) {
                    if (!manageUrlData) break block13;
                    error = "Unable to create URL data due to error: " + e.getMessage();
                }
            }
            if (urlContentData == null) {
                urlContentData = URLContentDTOFactory.createDummyURLContentData(taskInstanceId);
                if (error == null) {
                    error = "Task data missing";
                }
            }
            if (urlData == null) {
                req.setAttribute(JSP_RESOURCE_PRESENT_TAG, (Object)"false");
                urlData = URLContentDTOFactory.createDummyURLData(entryId);
                if (manageUrlData && error == null) {
                    error = "Task data missing";
                }
            } else {
                req.setAttribute(JSP_RESOURCE_PRESENT_TAG, (Object)"true");
            }
            if (error != null) {
                this.prepareList(req, staff, mode, error);
                return null;
            }
            String actor = staff ? JSPINPUT_ACTOR_STAFF_TAG : JSPINPUT_ACTOR_LEARNER_TAG;
            log.debug((Object)("staff is " + staff + " actor is " + actor + " userid is " + userId));
            String urlA = this.buildUrlA(req.getContextPath(), toolPath, actionName, actionMethodName, taskInstanceId, entryId, mode, userId, actor);
            String urlB = this.buildUrlB(urlData.getUrl(), res, req, urlData.isPreferDownload());
            log.debug((Object)("getFrameset: Access url is " + urlB));
            String framesetPath = this.buildFramesetPath(res, req.getContextPath(), urlA, urlB);
            log.debug((Object)("Redirecting to " + framesetPath));
            return framesetPath;
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    protected String buildUrlA(String contextPath, String toolPath, String actionName, String actionMethodName, int taskInstanceId, int entryId, String mode, long learnerUserId, String actor) {
        return contextPath + "/" + toolPath + actionName + ".do?method=" + actionMethodName + "&" + this.buildParams(taskInstanceId, entryId, mode, learnerUserId, actor);
    }

    protected String buildUrlB(String uriString, HttpServletResponse res, HttpServletRequest req, boolean preferDownload) {
        return FileManagerDelegate.getAccessUrl(uriString, res, req, preferDownload);
    }

    protected String buildParams(int taskInstanceId, int entryId, String mode, long learnerUserId, String actor) {
        String ret = JSP_TASK_INSTANCE_ID_TAG + "=" + taskInstanceId + "&" + JSP_URL_ID_TAG + "=" + entryId + "&" + JSPINPUT_ACTOR_TAG + "=" + actor + "&" + JSP_MODE_TAG + "=" + mode;
        if ("checkup".equals(mode)) {
            ret = ret + "&" + JSP_LEARNER_USER_ID_TAG + "=" + learnerUserId;
        }
        return ret;
    }

    protected String buildUrlB(String contextPath, String toolPath, String actionName, String urluri, boolean preferDownload) {
        String pageURL = null;
        log.debug((Object)("buildUrlB returns " + pageURL));
        return pageURL;
    }

    protected String buildFramesetPath(HttpServletResponse res, String contextPath, String urlA, String urlB) throws UnsupportedEncodingException {
        StringBuffer path = new StringBuffer(100);
        path.append(contextPath);
        path.append("/dynamicFrameSet.jsp?urlA=");
        if (urlA != null) {
            path.append(URLEncoder.encode(urlA, URL_ENCODING));
        }
        path.append("&urlB=");
        if (urlB != null) {
            path.append(URLEncoder.encode(urlB, URL_ENCODING));
        }
        path.append("&type=h&aPercent=20");
        return path.toString();
    }

    public void prepareContent(HttpServletRequest req) throws IOException, ServletException {
        try {
            int taskInstanceId = WebUtil.readIntParam(req, JSP_TASK_INSTANCE_ID_TAG);
            log.debug((Object)("prepareContent taskInstanceId: " + taskInstanceId));
            int entryId = WebUtil.readIntParam(req, JSP_URL_ID_TAG);
            String mode = this.getMode(null, req);
            long userId = this.getUserId(req, mode);
            boolean staff = this.isStaff(req);
            int previousInstructionNo = -1;
            try {
                previousInstructionNo = WebUtil.readIntParam(req, JSPINPUT_INSTRUCTION_NO_TAG);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            ++previousInstructionNo;
            if (mode == null) {
                mode = defaultAccessMode;
            }
            URLData urlData = null;
            URLContentData contentData = null;
            String error = null;
            URLContentService service = URLContentServiceUtil.getHome().create();
            try {
                contentData = service.getGeneralInfo(taskInstanceId, userId);
                urlData = service.getURLDetails(taskInstanceId, userId, entryId, previousInstructionNo);
            }
            catch (URLContentException e) {
                error = "Unable to create URL data due to error: " + e.getMessage();
            }
            log.debug((Object)("urlData is " + urlData));
            log.debug((Object)("Mode is " + mode));
            log.debug((Object)("Error is " + error));
            if (contentData == null) {
                contentData = URLContentDTOFactory.createDummyURLContentData(taskInstanceId);
                if (error == null) {
                    error = "Task data missing";
                }
            }
            if (urlData == null) {
                req.setAttribute(JSP_RESOURCE_PRESENT_TAG, (Object)"false");
                urlData = URLContentDTOFactory.createDummyURLData(entryId);
                if (error == null) {
                    error = "Task data missing";
                }
            } else {
                req.setAttribute(JSP_RESOURCE_PRESENT_TAG, (Object)"true");
            }
            req.setAttribute(JSPINPUT_INFO_TAG, (Object)contentData);
            req.setAttribute(JSPINPUT_URLDATA_TAG, (Object)urlData);
            req.setAttribute(JSP_MODE_TAG, (Object)mode);
            req.setAttribute(JSP_TASK_INSTANCE_ID_TAG, (Object)new Integer(taskInstanceId));
            if (error != null) {
                req.setAttribute(JSPINPUT_ERROR_TAG, (Object)error);
            }
            String actor = staff ? JSPINPUT_ACTOR_STAFF_TAG : JSPINPUT_ACTOR_LEARNER_TAG;
            log.debug((Object)("staff is " + staff + " actor is " + actor));
            req.setAttribute(JSPINPUT_ACTOR_TAG, (Object)actor);
            service.remove();
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception thrown", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

