/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.usermanagement.sysadmin.web;

import com.webmcq.ld.usermanagement.OrganisationRecursiveData;
import com.webmcq.ld.usermanagement.RequestUtil;
import com.webmcq.ld.usermanagement.UserManagementAuthorisationException;
import com.webmcq.ld.usermanagement.UserManagementException;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.usermanagement.interfaces.UserManagementService;
import com.webmcq.ld.usermanagement.interfaces.UserManagementServiceHome;
import com.webmcq.ld.usermanagement.interfaces.UserManagementServiceUtil;
import com.webmcq.ld.util.ObjectMessage;
import com.webmcq.ld.util.WDDXProcessor;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class ClientRequestAction
extends DispatchAction {
    private static Logger log = Logger.getLogger((String)(class$com$webmcq$ld$usermanagement$sysadmin$web$ClientRequestAction == null ? (class$com$webmcq$ld$usermanagement$sysadmin$web$ClientRequestAction = ClientRequestAction.class$("com.webmcq.ld.usermanagement.sysadmin.web.ClientRequestAction")) : class$com$webmcq$ld$usermanagement$sysadmin$web$ClientRequestAction).getName());
    public static final String ORGANISATIONID_TAG = "organisationid";
    static /* synthetic */ Class class$com$webmcq$ld$usermanagement$sysadmin$web$ClientRequestAction;
    static /* synthetic */ Class class$com$webmcq$ld$usermanagement$interfaces$UserManagementServiceHome;

    protected UserManagementService getService() throws NamingException, RemoteException, CreateException {
        InitialContext lContext = new InitialContext();
        UserManagementServiceHome home = (UserManagementServiceHome)PortableRemoteObject.narrow((Object)lContext.lookup("java:comp/env/ejb/usermanagement/UserManagementService"), (Class)(class$com$webmcq$ld$usermanagement$interfaces$UserManagementServiceHome == null ? (class$com$webmcq$ld$usermanagement$interfaces$UserManagementServiceHome = ClientRequestAction.class$("com.webmcq.ld.usermanagement.interfaces.UserManagementServiceHome")) : class$com$webmcq$ld$usermanagement$interfaces$UserManagementServiceHome));
        UserManagementService service = home.create();
        return service;
    }

    public ActionForward getOrganisations(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug((Object)"getOrganisations");
        OrganisationRecursiveData[] orgs = null;
        try {
            UserManagementService service = UserManagementServiceUtil.getHome().create();
            Long adminUserId = RequestUtil.getUserId(request, service);
            Set orgSet = service.getAllOrganisations(adminUserId);
            if (orgSet == null || orgSet.size() == 0) {
                log.warn((Object)("No organisations found for user " + adminUserId));
                orgs = new OrganisationRecursiveData[]{};
            } else {
                Iterator iter = orgSet.iterator();
                while (iter.hasNext()) {
                    OrganisationRecursiveData org = (OrganisationRecursiveData)iter.next();
                    if (!org.isAccountOrganisation()) continue;
                    iter.remove();
                }
            }
            orgs = orgSet.toArray(new OrganisationRecursiveData[orgSet.size()]);
        }
        catch (RemoteException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (UserManagementException e) {
            log.error((Object)"UserManagementException occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        log.debug((Object)("getOrganisations: orgs= " + orgs));
        ObjectMessage oMsg = new ObjectMessage(orgs, "getOrganisations");
        String msg = WDDXProcessor.serialize(oMsg);
        response.getWriter().print(msg);
        return null;
    }

    public ActionForward getUsersFromOrganisation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        log.debug((Object)"getUsersFromOrganisation");
        ShwaaUserData[] users = null;
        Long orgId = RequestUtil.getLongParameter(request, ORGANISATIONID_TAG);
        if (orgId == null) {
            log.warn((Object)"getUsersFromOrganisation: orgId is null");
        } else {
            try {
                UserManagementService service = UserManagementServiceUtil.getHome().create();
                Long adminUserId = RequestUtil.getUserId(request, service);
                SortedSet userSet = service.getUsersFromOrganisation(orgId, adminUserId);
                if (userSet != null) {
                    users = new ShwaaUserData[userSet.size()];
                    Iterator iter = userSet.iterator();
                    int i = 0;
                    while (iter.hasNext()) {
                        ShwaaUserData userData = (ShwaaUserData)iter.next();
                        userData.setPassword("");
                        users[i] = userData;
                        ++i;
                    }
                }
            }
            catch (RemoteException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                throw new EJBException((Exception)e);
            }
            catch (CreateException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                throw new EJBException((Exception)((Object)e));
            }
            catch (NamingException e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                throw new EJBException((Exception)e);
            }
            catch (UserManagementException e) {
                log.error((Object)"UserManagementException occured ", (Throwable)e);
                throw new EJBException((Exception)e);
            }
            catch (UserManagementAuthorisationException e) {
                log.error((Object)"UserManagementAuthorisationException occured ", (Throwable)e);
                throw new EJBException((Exception)e);
            }
        }
        if (users == null) {
            users = new ShwaaUserData[]{};
        }
        log.debug((Object)("getUsersFromOrganisation: users = " + users.toString()));
        ObjectMessage oMsg = new ObjectMessage(users, "getUsersFromOrganisation");
        String msg = WDDXProcessor.serialize(oMsg);
        response.getWriter().print(msg);
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

