/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.ld.security;

import com.webmcq.ld.ws.ExtServerOrgMapManager;
import com.webmcq.ld.ws.dao.ServerNotFoundException;
import java.security.NoSuchAlgorithmException;
import org.lamsfoundation.ld.security.AuthenticateException;
import org.lamsfoundation.ld.util.HashUtil;

public class Authenticator {
    public static void authenticate(String datetime, String username, String method, String serverId, String hashValue) throws AuthenticateException, ServerNotFoundException {
        String plaintext = datetime.toLowerCase().trim() + username.toLowerCase().trim() + method.toLowerCase().trim() + serverId.toLowerCase().trim() + ExtServerOrgMapManager.getExtServerOrgMapById(serverId).getServerkey().toLowerCase().trim();
        Authenticator.checkHash(plaintext, hashValue);
    }

    public static void authenticate(String datetime, String username, String serverId, String hashValue) throws AuthenticateException, ServerNotFoundException {
        String plaintext = datetime.toLowerCase().trim() + username.toLowerCase().trim() + serverId.toLowerCase().trim() + ExtServerOrgMapManager.getExtServerOrgMapById(serverId).getServerkey().toLowerCase().trim();
        Authenticator.checkHash(plaintext, hashValue);
    }

    public static void authenticate(String datetime, String serverId, String hashValue) throws AuthenticateException, ServerNotFoundException {
        String plaintext = datetime.toLowerCase().trim() + serverId.toLowerCase().trim() + ExtServerOrgMapManager.getExtServerOrgMapById(serverId).getServerkey().toLowerCase().trim();
        Authenticator.checkHash(plaintext, hashValue);
    }

    private static void checkHash(String plaintext, String hashValue) throws AuthenticateException {
        try {
            if (!hashValue.equals(HashUtil.sha1(plaintext))) {
                throw new AuthenticateException("Authentication failed!");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new AuthenticateException("The system does not support authentication!");
        }
    }
}

