/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.ld.util;

import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.ws.ExtCourseClassMap;
import com.webmcq.ld.ws.ExtCourseClassMapManager;
import com.webmcq.ld.ws.UserManagementServiceDelegate;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class MethodDispatcher {
    public static String getMethodURL(HttpServletRequest request) throws ServletException {
        String p_method = request.getParameter("method");
        String p_learningSessionId = request.getParameter("lsid");
        String p_learningDesignId = request.getParameter("ldid");
        String p_courseId = request.getParameter("course_id");
        String p_serverId = request.getParameter("sid");
        String p_userId = request.getParameter("uid");
        HttpSession hses = request.getSession();
        hses.removeAttribute("classId");
        hses.removeAttribute("designId");
        hses.removeAttribute("learningSessionId");
        hses.removeAttribute("learningSessionStatus");
        String lamsUsername = (String)hses.getAttribute("lamsUsername");
        if (p_method == null || p_method.equals("author") || p_method.equals("learner") && p_learningSessionId != null && p_courseId != null || !p_method.equals("monitor") || p_courseId == null) {
            // empty if block
        }
        if (p_method == null) {
            return "/lams/index.jsp";
        }
        if (p_method.equals("author")) {
            if (p_learningDesignId != null) {
                request.getSession().setAttribute("designId", (Object)p_learningDesignId);
            }
            return "/lams/home.do?method=author";
        }
        if (p_method.equals("monitor") && p_courseId != null) {
            if (p_learningSessionId != null) {
                request.getSession().setAttribute("learningSessionId", (Object)p_learningSessionId);
            }
            MethodDispatcher.setClassId(request.getSession(), p_courseId, p_serverId, p_userId);
            return "/lams/home.do?method=staff";
        }
        if (p_method.equals("learner") && p_courseId != null) {
            if (p_learningSessionId != null) {
                request.getSession().setAttribute("learningSessionId", (Object)p_learningSessionId);
                MethodDispatcher.setLearningSessionStatus(hses, lamsUsername, p_learningSessionId);
            }
            MethodDispatcher.setClassId(hses, p_courseId, p_serverId, p_userId);
            return "/lams/home.do?method=learner";
        }
        return "/lams/index.jsp";
    }

    private static void setClassId(HttpSession session, String courseId, String serverId, String userId) throws ServletException {
        ExtCourseClassMap extCourseClassMap = ExtCourseClassMapManager.getExtCourseClassMapByCourseIdAndServerId(courseId, serverId);
        try {
            if (extCourseClassMap == null) {
                session.setAttribute("classId", (Object)Long.toString(UserManagementServiceDelegate.createClass(serverId, courseId, null, null)));
            } else {
                session.setAttribute("classId", (Object)Long.toString(extCourseClassMap.getClassid()));
            }
            UserManagementServiceDelegate.addMembership(serverId, userId, courseId);
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private static void setLearningSessionStatus(HttpSession session, String username, String sessionId) throws ServletException {
        try {
            String status = Integer.toString(LearnerServiceDelegate.getProgressStatus(username, Long.parseLong(sessionId)));
            session.setAttribute("learningSessionStatus", (Object)status);
        }
        catch (UserNotFoundException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }
}

