<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>
<xsl:template match="/">
<table width="100%">
    <tr>
        <td>
            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr> 
                    <td class="subHeader">First message: </td>
                    <td align="right" class="body"><xsl:value-of select="/subject/@authorname"/> : <xsl:value-of select="/subject/@postdate"/></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr> 
        <td bgcolor="#660000">
            <table width="100%" border="0" cellpadding="2" cellspacing="0" >
                <tr>
                    <td><font color="#FFFFFF"><span class="bodyBoldOnDark"><xsl:value-of select="/subject/@subject"/></span></font></td>
                </tr>
                <tr bgcolor="#FFFFFF" class="body">
                    <td colspan="2"><div style='white-space:pre;'><xsl:value-of select="/subject/startmessage/@message"/></div></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr><td><img src="/lams/images/tool/mb/shim.gif" height="10" width="1"/></td></tr>
    <tr>
        <td bgcolor="#FFFFFF">
            <xsl:apply-templates/>
        </td>
    </tr>
</table>    
</xsl:template>
<xsl:template match="message">
    <!-- Add the | indent graphics -->
    <div>
    <table width="100%" border="0" cellspacing="0" cellpagging="0">
    <tr>
        <td rowspan="3">
            <nbsp>
            <xsl:for-each select="ancestor::*">
                <xsl:if test="name()!='subject' and name()!='startmessage'"><img src="/lams/images/tool/mb/shim.gif" width="20" height="1" border="0"/></xsl:if>
            </xsl:for-each>        
            </nbsp>
        </td>
        <td width="100%">
            <table width="100%" border="0" cellspacing="0" cellpagging="0" bgcolor="#D9E6E6">
                <tr>
                    <td>
                        <font color="#FFFFFF"><span class="smallText"><xsl:value-of select="@authorname"/> : <xsl:value-of select="@postdate"/></span></font>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td><pre class="body"><xsl:value-of select="@message" disable-output-escaping="yes"/></pre></td>
    </tr>
    <tr><td><hr/></td></tr>
    </table>
    </div>
    <!-- recurse through all nodes -->
    <xsl:apply-templates/>
</xsl:template>

<!-- write out the text -->
<xsl:template match="messageText"/>
</xsl:stylesheet>
